

<?php $__env->startSection('content'); ?>

<div class="p-6 text-gray-200">

    <!-- PAGE TITLE -->
    <h1 class="text-3xl font-bold mb-6">
        Group Loan — #<?php echo e($loan->id); ?>


        <span class="ml-3 px-3 py-1 rounded text-sm
            <?php if($loan->status == 'pending'): ?> bg-yellow-600
            <?php elseif($loan->status == 'approved'): ?> bg-blue-600
            <?php elseif($loan->status == 'active'): ?> bg-purple-600
            <?php elseif($loan->status == 'completed'): ?> bg-green-600
            <?php endif; ?>">
            <?php echo e(ucfirst($loan->status)); ?>

        </span>
    </h1>

    <!-- GRID -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">

        <!-- LOAN SUMMARY -->
        <div class="col-span-2 bg-gray-800 p-6 rounded-lg border border-gray-700 shadow">
            <h2 class="text-xl font-bold text-blue-300 mb-4">Loan Summary</h2>

            <div class="grid grid-cols-2 gap-4 text-gray-300">

                <p><strong>Group:</strong><br><?php echo e($loan->group->name); ?></p>

                <p><strong>Principal:</strong><br>
                    UGX <?php echo e(number_format($loan->principal)); ?>

                </p>

                <p><strong>Interest Rate:</strong><br><?php echo e($loan->interest_rate); ?>%</p>

                <p><strong>Loan Period:</strong><br>
                    <?php echo e($loan->loan_period_months); ?> Months
                </p>

                <p><strong>Balance:</strong><br>
                    <span class="text-yellow-300 font-bold">
                        UGX <?php echo e(number_format($loan->balance)); ?>

                    </span>
                </p>

                <p><strong>Created On:</strong><br>
                    <?php echo e($loan->created_at->format('d M Y')); ?>

                </p>

                <?php if($loan->approved_at): ?>
                <p><strong>Approved On:</strong><br>
                    <?php echo e(\Carbon\Carbon::parse($loan->approved_at)->format('d M Y')); ?>

                </p>
                <?php endif; ?>

                <?php if($loan->disbursed_at): ?>
                <p><strong>Disbursed On:</strong><br>
                    <?php echo e(\Carbon\Carbon::parse($loan->disbursed_at)->format('d M Y')); ?>

                </p>
                <?php endif; ?>

            </div>
        </div>

        <!-- GROUP MEMBERS -->
        <div class="bg-gray-800 p-6 rounded-lg border border-gray-700 shadow">
            <h2 class="text-xl font-bold text-green-300 mb-4">Group Members</h2>

           <?php $__currentLoopData = $loan->group->users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <div class="mb-3 p-3 bg-gray-900 rounded border border-gray-700">
                <p class="font-semibold text-white"><?php echo e($m->name); ?></p>
                <p class="text-sm text-gray-400"><?php echo e($m->email); ?></p>
                <p class="text-sm text-gray-400"><?php echo e($m->phone); ?></p>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

    </div>


    <!-- ADMIN ACTIONS -->
    <div class="bg-gray-800 p-6 rounded-lg border border-gray-700 shadow mt-8">
        <h2 class="text-xl font-bold text-purple-300 mb-4">Admin Actions</h2>

        <div class="flex flex-wrap gap-4">

            <?php if($loan->status === 'pending'): ?>
                <form action="<?php echo e(route('admin.group_loans.approve', $loan->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button class="px-4 py-2 bg-blue-600 hover:bg-blue-700 rounded text-white">
                        Approve Loan
                    </button>
                </form>
            <?php endif; ?>

            <?php if($loan->status === 'approved'): ?>
                <form action="<?php echo e(route('admin.group_loans.disburse', $loan->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button class="px-4 py-2 bg-purple-600 hover:bg-purple-700 rounded text-white">
                        Disburse Loan
                    </button>
                </form>
            <?php endif; ?>

            <?php if(in_array($loan->status, ['active', 'disbursed'])): ?>
                <button class="px-4 py-2 bg-green-600 hover:bg-green-700 rounded text-white"
                        onclick="document.getElementById('repayModal').showModal()">
                    Record Repayment
                </button>
            <?php endif; ?>

        </div>
    </div>


    <!-- REPAYMENT HISTORY -->
    <div class="bg-gray-800 p-6 rounded-lg border border-gray-700 shadow mt-8">
        <h2 class="text-xl font-bold text-yellow-300 mb-4">Repayment History</h2>

        <table class="w-full text-left text-gray-300">
            <thead class="bg-gray-700">
                <tr>
                    <th class="p-2">Date</th>
                    <th class="p-2">Member</th>
                    <th class="p-2">Amount</th>
                    <th class="p-2">Receipt</th>
                </tr>
            </thead>
            <tbody>

                <?php $__empty_1 = true; $__currentLoopData = $loan->repayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rep): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="border-b border-gray-700">
                    <td class="p-2"><?php echo e($rep->payment_date); ?></td>
                    <td class="p-2"><?php echo e($rep->member->name); ?></td>
                    <td class="p-2 text-green-400">UGX <?php echo e(number_format($rep->amount)); ?></td>
                    <td class="p-2">
                        <a href="<?php echo e(route('admin.repayments.receipt', $rep->id)); ?>"
                           class="text-blue-400 hover:text-blue-300">Print</a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="4" class="p-3 text-center text-gray-500">
                        No repayments recorded yet.
                    </td>
                </tr>
                <?php endif; ?>

            </tbody>
        </table>
    </div>

</div>


<!-- REPAYMENT MODAL -->
<!-- REPAYMENT MODAL -->
<dialog id="repayModal" class="bg-gray-800 p-6 rounded shadow-lg text-gray-200 w-96 border border-gray-700">

    <h3 class="text-xl font-bold mb-4">Record Repayment</h3>

    <form action="<?php echo e(route('admin.group_loan_repayments.store', $loan->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <!-- SELECT MEMBER PAYING -->
        <label class="block text-gray-300 mb-1">Member Paying</label>
        <select name="member_id"
                class="w-full p-2 mb-4 bg-gray-700 rounded border border-gray-600 text-white" required>
            <option value="">-- Select Member --</option>
            <?php $__currentLoopData = $loan->group->users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($member->id); ?>"><?php echo e($member->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>

        <!-- AMOUNT -->
        <label class="block text-gray-300 mb-1">Amount</label>
        <input type="number" name="amount"
               class="w-full p-2 mb-4 bg-gray-700 rounded border border-gray-600 text-white"
               placeholder="Enter amount" required>

        <!-- PAYMENT DATE -->
        <label class="block text-gray-300 mb-1">Payment Date</label>
        <input type="date" name="payment_date"
               class="w-full p-2 mb-4 bg-gray-700 rounded border border-gray-600 text-white"
               required>

        <!-- NOTES -->
        <label class="block text-gray-300 mb-1">Notes (optional)</label>
        <textarea name="notes" rows="2"
                  class="w-full p-2 bg-gray-700 rounded border border-gray-600 text-white"></textarea>

        <div class="flex justify-end gap-3 mt-4">
            <button type="button" onclick="repayModal.close()"
                    class="px-3 py-1 bg-gray-600 rounded hover:bg-gray-500">
                Cancel
            </button>

            <button class="px-3 py-1 bg-green-600 rounded hover:bg-green-700">
                Save Repayment
            </button>
        </div>

    </form>

</dialog>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/group_loans/show.blade.php ENDPATH**/ ?>