

<?php $__env->startSection('content'); ?>
<div class="p-6 space-y-6">

    <!-- Header -->
    <div class="flex justify-between items-center">
        <h2 class="text-2xl font-semibold text-gray-100">
            Loan #<?php echo e($loan->id); ?>

        </h2>

        <a href="<?php echo e(route('member.loans.index')); ?>"
           class="px-3 py-2 bg-gray-600 rounded text-white">
            Back
        </a>
    </div>

    <!-- Loan Summary -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">

        <!-- Summary Box -->
        <div class="bg-gray-800 p-4 rounded shadow">
            <h3 class="font-semibold text-gray-100 mb-3">Summary</h3>

            <p class="text-gray-300 mt-2"><strong>Type:</strong> <?php echo e($loan->loanType->name); ?></p>

            <p class="text-gray-300"><strong>Principal:</strong>
                UGX <?php echo e(number_format($loan->principal)); ?>

            </p>

            <p class="text-gray-300"><strong>Interest Rate:</strong>
                <?php echo e($loan->interest_rate); ?>%
            </p>

            <p class="text-gray-300"><strong>Total Payable:</strong>
                UGX <?php echo e(number_format($loan->total_payable)); ?>

            </p>

            <p class="text-gray-300"><strong>Remaining Balance:</strong>
                <span class="text-yellow-300 font-semibold">
                    UGX <?php echo e(number_format($loan->balance)); ?>

                </span>
            </p>

            <p class="text-gray-300"><strong>Status:</strong>
                <?php echo e(ucfirst($loan->status)); ?>

            </p>

            <p class="text-gray-300"><strong>Applied:</strong>
                <?php echo e($loan->created_at->format('Y-m-d')); ?>

            </p>

            <?php if($loan->approved_at): ?>
                <p class="text-gray-300"><strong>Approved:</strong>
                    <?php echo e($loan->approved_at->format('Y-m-d')); ?>

                </p>
            <?php endif; ?>

            <?php if($loan->disbursed_at): ?>
                <p class="text-gray-300"><strong>Disbursed:</strong>
                    <?php echo e($loan->disbursed_at->format('Y-m-d')); ?>

                </p>
            <?php endif; ?>
        </div>

        <!-- Repayments + Actions -->
        <div class="bg-gray-800 p-4 rounded shadow lg:col-span-2">

            <h3 class="font-semibold text-gray-100 mb-3">Repayment History</h3>

            <?php if($repayments->count()): ?>
                <table class="w-full text-sm text-gray-300 mb-6">
                    <thead class="bg-gray-700">
                        <tr>
                            <th class="p-2">Date</th>
                            <th class="p-2">Amount</th>
                            <th class="p-2">Recorded By</th>
                            <th class="p-2">Notes</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $repayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="border-t border-gray-700">
                                <td class="p-2"><?php echo e($r->created_at->format('Y-m-d')); ?></td>
                                <td class="p-2 text-green-400">UGX <?php echo e(number_format($r->amount)); ?></td>
                                <td class="p-2"><?php echo e($r->admin->name ?? 'System'); ?></td>
                                <td class="p-2"><?php echo e($r->notes); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="text-gray-400 mb-6">No repayments yet.</p>
            <?php endif; ?>

            <!-- Progress Bar -->
            <?php
                $paid = $loan->total_payable - $loan->balance;
                $percent = $loan->total_payable > 0 ? round(($paid / $loan->total_payable) * 100) : 0;
            ?>

            <div class="mb-6">
                <div class="h-3 bg-gray-700 rounded-full overflow-hidden">
                    <div class="h-3 bg-green-500 transition-all duration-700"
                         style="width: <?php echo e($percent); ?>%">
                    </div>
                </div>
                <p class="text-gray-400 text-sm mt-1"><?php echo e($percent); ?>% repaid</p>
            </div>

            <!-- Repayment Form -->
            <h3 class="font-semibold text-gray-100 mb-2">Make a Repayment</h3>

            <?php if($loan->status === 'closed'): ?>
                <p class="text-green-400 font-bold">This loan is fully paid.</p>
            <?php else: ?>
            <form action="<?php echo e(route('member.loans.repay', $loan->id)); ?>"
                  method="POST" id="memberRepayForm">
                <?php echo csrf_field(); ?>

                <label class="text-gray-300">Amount</label>
                <input type="number" name="amount" id="repayAmountInput"
                       class="w-full px-3 py-2 rounded bg-gray-700 text-gray-100 mt-1"
                       placeholder="Enter amount" required>

                <!-- Live Preview -->
                <p id="previewPay" class="text-gray-300 mt-2 hidden">
                    You will pay:
                    <span id="previewAmount" class="font-bold text-green-400"></span>
                </p>

                <p id="previewBalance" class="text-gray-300 mt-1 hidden">
                    New Balance:
                    <span id="previewNewBalance" class="font-bold text-yellow-300"></span>
                </p>

                <p id="warningMsg" class="text-red-400 text-sm mt-2 hidden font-semibold">
                    ⚠ Amount exceeds outstanding balance!
                </p>

                <label class="text-gray-300 mt-3 block">Notes (optional)</label>
                <textarea name="notes" class="w-full p-2 rounded bg-gray-700 text-gray-100"></textarea>

                <button id="submitBtn"
                    class="mt-4 w-full bg-green-600 hover:bg-green-700 p-2 rounded">
                    Submit Payment
                </button>
            </form>
            <?php endif; ?>
        </div>
    </div>
</div>


<script>
    const amountInput = document.getElementById('repayAmountInput');
    const outstanding = <?php echo e($loan->balance); ?>;
    const previewPay = document.getElementById('previewPay');
    const previewAmount = document.getElementById('previewAmount');
    const previewBalance = document.getElementById('previewBalance');
    const previewNewBalance = document.getElementById('previewNewBalance');
    const warningMsg = document.getElementById('warningMsg');
    const submitBtn = document.getElementById('submitBtn');

    amountInput?.addEventListener('input', function () {
        let value = parseFloat(this.value || 0);

        if (value > 0) {
            previewPay.classList.remove('hidden');
            previewBalance.classList.remove('hidden');
            previewAmount.textContent = "UGX " + value.toLocaleString();
            previewNewBalance.textContent =
                "UGX " + (outstanding - value).toLocaleString();
        } else {
            previewPay.classList.add('hidden');
            previewBalance.classList.add('hidden');
        }

        if (value > outstanding) {
            warningMsg.classList.remove('hidden');
            submitBtn.disabled = true;
            submitBtn.classList.add('opacity-50', 'cursor-not-allowed');
        } else {
            warningMsg.classList.add('hidden');
            submitBtn.disabled = false;
            submitBtn.classList.remove('opacity-50', 'cursor-not-allowed');
        }
    });
</script>


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
document.querySelector('#memberRepayForm').addEventListener('submit', function(e) {
    e.preventDefault();

    Swal.fire({
        title: 'Confirm Repayment',
        text: 'Are you sure you want to submit this repayment?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#16a34a',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, Submit'
    }).then((result) => {
        if (result.isConfirmed) {
            this.submit();
        }
    });
});
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.member', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/member/loans/show.blade.php ENDPATH**/ ?>