

<?php $__env->startSection('content'); ?>
<div class="p-6 text-gray-100 max-w-3xl">

    <h1 class="text-2xl font-bold mb-4">Edit Income</h1>

    <form action="<?php echo e(route('admin.incomes.update', $income->id)); ?>" 
          method="POST" class="space-y-4 bg-gray-800 p-6 rounded">

        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        
        <div>
            <label class="text-sm">Income Type</label>
            <select name="income_type_id" class="w-full bg-gray-700 px-3 py-2 rounded" required>
                <?php $__currentLoopData = $incomeTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($type->id); ?>"
                        <?php echo e($income->income_type_id == $type->id ? 'selected' : ''); ?>>
                        <?php echo e($type->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        
        <div>
            <label class="text-sm">Member (Optional)</label>
            <select name="member_id" class="w-full bg-gray-700 px-3 py-2 rounded">
                <option value="">— None —</option>
                <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($member->id); ?>"
                        <?php echo e($income->member_id == $member->id ? 'selected' : ''); ?>>
                        <?php echo e($member->name); ?> (<?php echo e($member->member_id); ?>)
                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        
        <div>
            <label class="text-sm">Deposit Into Account</label>
            <select name="account_id" class="w-full bg-gray-700 px-3 py-2 rounded" required>
                <option value="">-- Select Account --</option>

                <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($account->id); ?>"
                        <?php echo e($income->account_id == $account->id ? 'selected' : ''); ?>>
                        <?php echo e($account->account_number); ?> — (UGX <?php echo e(number_format($account->balance,0)); ?>)
                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        
        <div>
            <label class="text-sm">Payment Method</label>
            <select name="payment_method" class="w-full bg-gray-700 px-3 py-2 rounded" required>
                <?php $__currentLoopData = ['Cash', 'Mobile Money', 'Bank']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($method); ?>"
                        <?php echo e($income->payment_method == $method ? 'selected' : ''); ?>>
                        <?php echo e($method); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        
        <div>
            <label class="text-sm">Amount (UGX)</label>
            <input type="number" step="0.01" name="amount"
                   value="<?php echo e($income->amount); ?>"
                   class="w-full bg-gray-700 px-3 py-2 rounded" required>
        </div>

        
        <div>
            <label class="text-sm">Income Date</label>
            <input type="date" name="income_date"
                   value="<?php echo e($income->income_date); ?>"
                   class="w-full bg-gray-700 px-3 py-2 rounded" required>
        </div>

        
        <div>
            <label class="text-sm">Description</label>
            <textarea name="description" rows="3"
                      class="w-full bg-gray-700 px-3 py-2 rounded"><?php echo e($income->description); ?></textarea>
        </div>

        <button class="bg-blue-600 px-4 py-2 rounded hover:bg-blue-700">Update Income</button>
    </form>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/incomes/edit.blade.php ENDPATH**/ ?>