


<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto px-4 lg:px-0 py-8">

    <h1 class="text-3xl font-semibold text-white mb-6">Policies & Agreements</h1>

    <?php $__currentLoopData = $policies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <article class="mb-6 bg-gray-800 rounded-lg border border-gray-700 shadow-sm overflow-hidden">
        <header class="px-6 py-4 flex items-start justify-between gap-4">
            <div>
                <h2 class="text-xl font-semibold text-blue-300 mb-1"><?php echo e($policy->title); ?></h2>
                <?php if($policy->description): ?>
                    <p class="text-sm text-gray-400"><?php echo e($policy->description); ?></p>
                <?php endif; ?>
            </div>

            <div class="text-right space-y-2">
                
                <div class="text-xs text-gray-400">Version: <span class="font-medium text-gray-200"><?php echo e($policy->version ?? '1.0'); ?></span></div>

                
                <div>
<?php
    $hasPdfRoute = \Illuminate\Support\Facades\Route::has('member.policies.pdf');
    $pdfUrl = $hasPdfRoute ? route('member.policies.pdf', $policy) : '#';
?>

<a href="<?php echo e($pdfUrl); ?>"
   class="text-sm inline-flex items-center px-3 py-1 rounded bg-gray-700 hover:bg-gray-600 text-gray-200 <?php echo e($hasPdfRoute ? '' : 'opacity-60 cursor-not-allowed'); ?>"
   <?php if(! $hasPdfRoute): ?> title="PDF export not configured" <?php endif; ?>>
   ⤓ PDF
</a>

                </div>
            </div>
        </header>

        
        <div class="px-6 pb-6">
            <details class="mb-4">
                <summary class="text-yellow-300 cursor-pointer font-medium">▼ View Policy Content</summary>

                <div class="mt-3 text-gray-300 leading-relaxed prose prose-invert max-w-none">
                    
                    <?php echo \Illuminate\Support\Str::markdown($policy->content); ?>

                </div>
            </details>

            <div class="flex items-center justify-between">
                <div>
                    <?php if(in_array($policy->id, $userAgreements ?? [])): ?>
                        <span class="inline-flex items-center gap-2 px-3 py-1 rounded bg-emerald-900 text-emerald-300 text-sm font-semibold">
                            ✓ You already agreed to this policy.
                        </span>

                        
                    <?php else: ?>
                        
                        <form action="<?php echo e(route('member.policies.agree', $policy)); ?>" method="POST" class="inline">
                            <?php echo csrf_field(); ?>
                            <button
                                type="submit"
                                class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-green-500">
                                I Agree
                            </button>
                        </form>
                    <?php endif; ?>
                </div>

                <div class="text-sm text-gray-400">
                    <span>Published: </span>
                    <span class="font-medium text-gray-200"><?php echo e(optional($policy->created_at)->format('d M Y') ?? '-'); ?></span>
                </div>
            </div>
        </div>
    </article>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <?php if (! ($policies->count())): ?>
        <div class="bg-gray-800 p-6 rounded-lg text-gray-400">
            No active policies available.
        </div>
    <?php endif; ?>

</div>
<?php $__env->stopSection(); ?>


<?php if (! $__env->hasRenderedOnce('3ff409ae-e3c9-4e52-b68d-240c23106732')): $__env->markAsRenderedOnce('3ff409ae-e3c9-4e52-b68d-240c23106732'); ?>
<?php
if (! function_exists('route_exists')) {
    function route_exists($name) {
        try {
            return \Illuminate\Support\Facades\Route::has($name);
        } catch (\Throwable $e) {
            return false;
        }
    }
}
?>
<?php endif; ?>

<?php echo $__env->make('layouts.member', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/member/policies/index.blade.php ENDPATH**/ ?>