

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-6 py-6">

    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold text-white">Account Types</h1>

        <a href="<?php echo e(route('admin.account_types.create')); ?>"
           class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded shadow">
            + Add Account Type
        </a>
    </div>

    <div class="bg-gray-800 text-gray-200 rounded-lg shadow overflow-hidden">
        <table class="w-full">
            <thead class="bg-gray-700 text-gray-300 uppercase text-sm">
                <tr>
                    <th class="px-4 py-3 text-left">Name</th>
                    <th class="px-4 py-3 text-left">Min Balance</th>
                    <th class="px-4 py-3 text-left">Interest Rate (%)</th>
                    <th class="px-4 py-3 text-left">Has Interest?</th>
                    <th class="px-4 py-3 text-left">Status</th>
                    <th class="px-4 py-3 text-left">Actions</th>
                </tr>
            </thead>

            <tbody>
                <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="border-b border-gray-700">
                    <td class="px-4 py-3"><?php echo e($type->name); ?></td>
                    <td class="px-4 py-3"><?php echo e(number_format($type->min_balance)); ?></td>
                    <td class="px-4 py-3"><?php echo e($type->interest_rate); ?>%</td>
                    <td class="px-4 py-3"><?php echo e($type->has_interest ? 'Yes' : 'No'); ?></td>

                    <td class="px-4 py-3">
                        <?php if($type->status === 'active'): ?>
                            <span class="text-green-400 font-semibold">Active</span>
                        <?php else: ?>
                            <span class="text-red-400 font-semibold">Inactive</span>
                        <?php endif; ?>
                    </td>

                    <td class="px-4 py-3 flex gap-4">

                        
                        <a href="<?php echo e(route('admin.account_types.edit', $type->id)); ?>"
                           class="text-blue-400 hover:text-blue-600">Edit</a>

                        
                        <form action="<?php echo e(route('admin.account_types.destroy', $type->id)); ?>"
                              method="POST"
                              onsubmit="return confirm('Delete this account type?');">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button class="text-red-400 hover:text-red-600">Delete</button>
                        </form>

                        
                        <form action="<?php echo e(route('admin.account_types.toggle_status', $type->id)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <button class="text-yellow-400 hover:text-yellow-600">
                                <?php echo e($type->status === 'active' ? 'Deactivate' : 'Activate'); ?>

                            </button>
                        </form>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>

        </table>
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/account_types/index.blade.php ENDPATH**/ ?>