

<?php $__env->startSection('content'); ?>

<div class="p-6 text-gray-200">

    <h1 class="text-3xl font-bold mb-6">Group Loans</h1>

    <div class="bg-gray-800 rounded-lg shadow border border-gray-700 p-4">
        <table class="w-full text-left text-gray-300">
            <thead class="bg-gray-700">
                <tr>
                    <th class="p-2">Loan ID</th>
                    <th class="p-2">Group</th>
                    <th class="p-2">Principal</th>
                    <th class="p-2">Balance</th>
                    <th class="p-2">Status</th>
                    <th class="p-2">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="border-b border-gray-700">
                    <td class="p-2">#<?php echo e($loan->id); ?></td>
                    <td class="p-2"><?php echo e($loan->group->name); ?></td>
                    <td class="p-2">UGX <?php echo e(number_format($loan->principal)); ?></td>
                    <td class="p-2 text-yellow-300">
                        UGX <?php echo e(number_format($loan->balance)); ?>

                    </td>
                    <td class="p-2">
                        <span class="px-2 py-1 rounded text-sm
                            <?php if($loan->status == 'pending'): ?> bg-yellow-600
                            <?php elseif($loan->status == 'approved'): ?> bg-blue-600
                            <?php elseif($loan->status == 'active'): ?> bg-purple-600
                            <?php elseif($loan->status == 'completed'): ?> bg-green-600
                            <?php endif; ?>">
                            <?php echo e(ucfirst($loan->status)); ?>

                        </span>
                    </td>
                    <td class="p-2">
                        <a href="<?php echo e(route('admin.group_loans.show', $loan->id)); ?>"
                           class="text-blue-400 hover:text-blue-300">
                            View
                        </a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="p-4 text-center text-gray-500">
                        No group loans found.
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/group_loans/index.blade.php ENDPATH**/ ?>