

<?php $__env->startSection('content'); ?>
<div class="p-6">
    <div class="flex justify-between items-center mb-4">
        <div>
            <h2 class="text-2xl font-bold text-white"><?php echo e($group->name); ?></h2>
            <p class="text-gray-400">Status: <?php echo e(ucfirst($group->status)); ?></p>
        </div>
        <div class="space-x-2">
            <a href="<?php echo e(route('admin.groups.index')); ?>" class="px-3 py-2 bg-gray-600 rounded text-white">Back</a>
            <a href="<?php echo e(route('admin.groups.edit', $group->id)); ?>" class="px-3 py-2 bg-yellow-600 rounded text-white">Edit</a>
            <a href="<?php echo e(route('admin.group_loans.create', $group->id)); ?>" class="px-3 py-2 bg-blue-600 rounded text-white">Add Group loan</a>
        </div>
    </div>

    <?php if(session('success')): ?> <div class="mb-3 p-3 bg-green-600 text-white"><?php echo e(session('success')); ?></div> <?php endif; ?>
    <?php if(session('error')): ?> <div class="mb-3 p-3 bg-red-600 text-white"><?php echo e(session('error')); ?></div> <?php endif; ?>

    <div class="bg-gray-800 p-4 rounded mb-6">
        <h3 class="text-lg font-semibold text-white mb-3">Members (<?php echo e($group->activeMembersCount()); ?> active)</h3>

        <table class="w-full text-left text-gray-300">
            <thead class="bg-gray-700 text-gray-100">
                <tr>
                    <th class="py-2 px-3">Name</th>
                    <th class="py-2 px-3">Phone</th>
                    <th class="py-2 px-3">Status</th>
                    <th class="py-2 px-3">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $group->members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="border-t border-gray-700">
                        <td class="py-2 px-3"><?php echo e($member->user->name ?? 'N/A'); ?></td>
                        <td class="py-2 px-3"><?php echo e($member->user->phone ?? 'N/A'); ?></td>
                        <td class="py-2 px-3"><?php echo e(ucfirst($member->status)); ?></td>
                        <td class="py-2 px-3">
                            <form action="<?php echo e(route('admin.groups.members.toggle', [$group->id, $member->id])); ?>" method="POST" class="inline">
                                <?php echo csrf_field(); ?>
                                <button class="text-yellow-400"><?php echo e($member->status=='active' ? 'Deactivate' : 'Activate'); ?></button>
                            </form>

                            <form action="<?php echo e(route('admin.groups.members.remove', [$group->id, $member->id])); ?>" method="POST" class="inline" onsubmit="return confirm('Remove member?');">
                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                <button class="text-red-400 ml-3">Remove</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr><td colspan="4" class="py-4 text-gray-400">No members yet.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="bg-gray-800 p-4 rounded">
        <h3 class="text-lg font-semibold text-white mb-3">Add Member</h3>

        <form action="<?php echo e(route('admin.groups.members.add', $group->id)); ?>" method="POST" class="grid grid-cols-1 md:grid-cols-3 gap-3">
            <?php echo csrf_field(); ?>
            <select name="user_id" class="p-2 rounded bg-gray-700 text-white">
                <option value="">Select member to add</option>
                <?php $__currentLoopData = $eligible; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($u->id); ?>"><?php echo e($u->name); ?> (<?php echo e($u->member_id ?? 'MBR'); ?>)</option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <div class="md:col-span-2">
                <button class="px-4 py-2 bg-green-600 rounded text-white">Add Member</button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/groups/show.blade.php ENDPATH**/ ?>