<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo e($policy->title); ?> - Policy Document</title>

    <style>
        body {
            font-family: "DejaVu Sans", sans-serif;
            margin: 40px;
            font-size: 12px;
            color: #222;
            line-height: 1.6;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 1px solid #ccc;
        }

        .header h1 {
            margin: 0;
            font-size: 22px;
        }

        .header p {
            margin: 0;
            font-size: 12px;
        }

        .section-title {
            font-size: 16px;
            margin-top: 25px;
            margin-bottom: 10px;
            font-weight: bold;
        }

        .content {
            margin-top: 10px;
            white-space: pre-line;
        }

        .footer {
            position: fixed;
            bottom: 20px;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 10px;
            color: #777;
        }

        .meta {
            margin-top: 5px;
            font-size: 11px;
            color: #555;
        }
    </style>
</head>

<body>

    
    <div class="header">
        <h1>HOSANNA SACCO</h1>
        <p><strong>Official Policy Document</strong></p>
        <p class="meta">Generated on: <?php echo e(now()->format('d M Y')); ?></p>
    </div>

    
    <div>
        <h2 class="section-title"><?php echo e($policy->title); ?></h2>

        <p class="meta"><strong>Version:</strong> <?php echo e($policy->version); ?></p>

        <?php if($policy->description): ?>
            <p class="meta"><strong>Description:</strong> <?php echo e($policy->description); ?></p>
        <?php endif; ?>
    </div>

    
    <div class="content">
        <?php echo nl2br($policy->content); ?>

    </div>

    
    <div class="footer">
        HOSANNA SACCO • This is an auto-generated document • Page <span class="page-number"></span>
    </div>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\myproject\resources\views/member/policies/pdf.blade.php ENDPATH**/ ?>