

<?php $__env->startSection('content'); ?>
<div class="flex justify-center p-6 bg-gray-900 text-gray-200 min-h-screen">
    <div class="w-full max-w-2xl">

        <div class="bg-gray-800 shadow-lg rounded-xl p-6 border border-gray-700">
            <h1 class="text-2xl font-bold mb-6 text-blue-400">Apply for a Loan</h1>

            <form id="loanForm" action="<?php echo e(route('member.loans.submit')); ?>" method="POST" class="space-y-5">
                <?php echo csrf_field(); ?>

                
                <div class="space-y-1">
                    <label class="block text-sm font-semibold text-gray-300">Loan Type</label>
                    <select name="loan_type_id" id="loan_type_id"
                        class="w-full px-4 py-2 rounded-lg bg-gray-700 border border-gray-600 focus:border-blue-500 focus:ring-1 focus:ring-blue-500"
                        required>
                        <option value="">Choose Loan Type...</option>
                        <?php $__currentLoopData = $loanTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($type->id); ?>" <?php if(old('loan_type_id')==$type->id): echo 'selected'; endif; ?>>
                                <?php echo e($type->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['loan_type_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-400 text-xs"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                
                <div class="space-y-1">
                    <label class="block text-sm font-semibold text-gray-300">Loan Amount (UGX)</label>
                    <input type="number" name="amount" min="1" value="<?php echo e(old('amount')); ?>"
                        class="w-full px-4 py-2 rounded-lg bg-gray-700 border border-gray-600 focus:border-blue-500 focus:ring-1 focus:ring-blue-500"
                        required>
                    <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-400 text-xs"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                
                <div id="asset_fields" class="hidden space-y-1">
                    <label class="block text-sm font-semibold text-gray-300">Asset Value</label>
                    <input type="number" min="1" name="asset_value" value="<?php echo e(old('asset_value')); ?>"
                        class="w-full px-4 py-2 rounded-lg bg-gray-700 border border-gray-600 focus:border-blue-500 focus:ring-1 focus:ring-blue-500">
                    <p class="text-gray-400 text-xs">Only required for Asset Financing.</p>
                </div>

                
                <div class="space-y-1">
                    <label class="block text-sm font-semibold text-gray-300">Loan Term (Months)</label>
                    <input type="number" min="1" name="term_months" value="<?php echo e(old('term_months')); ?>"
                        class="w-full px-4 py-2 rounded-lg bg-gray-700 border border-gray-600 focus:border-blue-500 focus:ring-1 focus:ring-blue-500">
                </div>

                
                <div class="space-y-1">
                    <label class="block text-sm font-semibold text-gray-300">Purpose / Notes</label>
                    <textarea name="purpose" rows="4"
                        class="w-full px-4 py-2 rounded-lg bg-gray-700 border border-gray-600 focus:border-blue-500 focus:ring-1 focus:ring-blue-500"><?php echo e(old('purpose')); ?></textarea>
                </div>

<div class="flex items-start gap-2 p-3 bg-gray-700 rounded-lg">
    <input type="checkbox" id="agree_terms" class="mt-1">
    <label for="agree_terms" class="text-sm text-gray-300">
        I confirm that I understand and accept all SACCO loan policies governing this loan, repayment obligations, interest rules, penalties, and member responsibilities. I agree that this loan is governed by the SACCO’s approved policies and internal regulations.
    </label>
</div>

<p id="agree_error" class="text-red-400 text-xs hidden">You must agree before submitting.</p>

                
                <div class="flex justify-end gap-3 pt-4">
                    <a href="<?php echo e(url()->previous()); ?>"
                        class="px-4 py-2 bg-gray-600 hover:bg-gray-500 rounded-lg text-white">
                        Cancel
                    </a>
                    <button class="px-4 py-2 bg-blue-600 hover:bg-blue-700 rounded-lg font-semibold">
                        Submit Application
                    </button>
                </div>

            </form>

            
        </div>
    </div>

    <!-- MODAL -->
<!-- CONSENT MODAL -->
<div id="consentModal"
     class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50">

    <div class="bg-gray-800 p-6 rounded-xl shadow-lg w-full max-w-md border border-gray-600">
        <h2 class="text-xl font-bold text-blue-400 mb-3">
            Loan Terms & Conditions
        </h2>

        <p class="text-gray-300 text-sm mb-4">
            By submitting this loan application, you confirm that you have read
            and agreed to all the SACCO policies and loan terms governing this product.
        </p>

        <div class="flex justify-end gap-3">
            <button id="cancelConsent"
                class="px-4 py-2 bg-gray-600 hover:bg-gray-500 rounded-lg text-white">
                Cancel
            </button>

            <button id="agreeConsent"
                class="px-4 py-2 bg-green-600 hover:bg-green-700 rounded-lg text-white">
                I Agree
            </button>
        </div>
    </div>
</div>


</div>

<script>
document.getElementById('loan_type_id').addEventListener('change', function () {
    const selected = this.options[this.selectedIndex].text.toLowerCase();
    document.getElementById('asset_fields').classList.toggle(
        'hidden',
        !selected.includes('asset')
    );
});
</script>

<script>
document.addEventListener("DOMContentLoaded", () => {

    const form = document.getElementById("loanForm");
    const modal = document.getElementById("consentModal");
    const agreeBtn = document.getElementById("agreeConsent");
    const cancelBtn = document.getElementById("cancelConsent");

    if (!form) {
        console.error("loanForm NOT FOUND — add id='loanForm' to your form.");
        return;
    }

    form.addEventListener("submit", function (e) {
        e.preventDefault();             // Stop submission
        modal.classList.remove("hidden"); // Show modal
    });

    cancelBtn.addEventListener("click", () => {
        modal.classList.add("hidden"); // Hide modal
    });

    agreeBtn.addEventListener("click", () => {
        modal.classList.add("hidden");
        form.submit();                 // Now submit for real
    });

});
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.member', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/loans/apply.blade.php ENDPATH**/ ?>