

<?php $__env->startSection('content'); ?>
<div class="p-6 max-w-2xl mx-auto">

    <h2 class="text-2xl font-semibold text-gray-100 mb-4">
        Create Group Loan for <?php echo e($group->name); ?>

    </h2>

    
    <?php if(session('success')): ?>
        <div class="bg-green-700 text-white p-4 rounded-lg shadow mb-6">
            <p class="font-semibold"><?php echo e(session('success')); ?></p>
        </div>
    <?php endif; ?>

    
    <form action="<?php echo e(route('admin.group_loans.store', $group->id)); ?>" method="POST"
          class="space-y-4 bg-gray-800 p-6 rounded-lg shadow border border-gray-700">
        <?php echo csrf_field(); ?>

        <div>
            <label class="block text-sm text-gray-300">Principal Amount</label>
            <input type="number" name="principal" step="0.01"
                   class="w-full p-2 rounded bg-gray-900 border border-gray-700 text-white"
                   required>
        </div>

        <div>
            <label class="block text-sm text-gray-300">Interest Rate (%)</label>
            <input type="number" name="interest_rate" step="0.01"
                   class="w-full p-2 rounded bg-gray-900 border border-gray-700 text-white"
                   required>
        </div>

        <div>
            <label class="block text-sm text-gray-300">Loan Period (Months)</label>
            <input type="number" name="loan_period_months"
                   class="w-full p-2 rounded bg-gray-900 border border-gray-700 text-white"
                   required>
        </div>

        <div class="pt-4 flex items-center">
            <button class="bg-blue-600 hover:bg-blue-700 text-white px-5 py-2 rounded">
                Create Loan
            </button>

            <a href="<?php echo e(route('admin.groups.index')); ?>"
               class="text-gray-400 ml-4 hover:text-gray-200">
                Cancel
            </a>
        </div>

    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/group_loans/create.blade.php ENDPATH**/ ?>