

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-6 py-6">

    <h1 class="text-2xl font-bold text-white text-center mb-6">
        Add Account
    </h1>

    <div class="max-w-2xl mx-auto bg-gray-800 p-8 rounded-lg shadow">

        <form action="<?php echo e(route('admin.accounts.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>

            
            <div class="mb-4">
                <label class="block text-gray-300 mb-2">Account Number</label>
                <input type="text"
                       value="<?php echo e($generated ?? 'HCS-XXXXXX'); ?>"
                       class="w-full p-2 bg-gray-700 text-gray-400 rounded"
                       readonly>
                <p class="text-xs text-gray-500 mt-1">This number is automatically generated.</p>
            </div>

            
            <div class="mb-4">
                <label class="block text-gray-300 mb-2">Member</label>
                <select name="user_id"
                        class="w-full p-2 bg-gray-700 text-white rounded" required>
                    <option value="">-- Select Member --</option>
                    <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($member->id); ?>">
                            <?php echo e($member->name); ?> (<?php echo e($member->email); ?>)
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            
            <div class="mb-4">
                <label class="block text-gray-300 mb-2">Account Type</label>
                <select name="account_type_id"
                        class="w-full p-2 bg-gray-700 text-white rounded" required>
                    <option value="">-- Select Type --</option>
                    <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($type->id); ?>">
                            <?php echo e($type->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            
            <div class="mb-6">
                <label class="block text-gray-300 mb-2">Notes / Description (Optional)</label>
                <textarea 
                    name="notes"
                    rows="3"
                    class="w-full p-2 bg-gray-700 text-gray-200 rounded"
                    placeholder="Add any notes about this account such as initial fees, special terms, restrictions, or opening remarks..."
                ></textarea>
            </div>

            
            <div class="flex items-center gap-4">
                <button type="submit"
                        class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">
                    Create Account
                </button>

                <a href="<?php echo e(route('admin.accounts.index')); ?>"
                   class="text-gray-400 hover:text-gray-200">
                    Cancel
                </a>
            </div>

        </form>

    </div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/accounts/create.blade.php ENDPATH**/ ?>