



<?php $__env->startSection('content'); ?>

<?php if(session('success')): ?>
    <div class="bg-green-700 text-white p-3 rounded mb-4">
        <?php echo e(session('success')); ?>

        <?php if(session('temp_password')): ?>
            <div class="mt-2 text-sm bg-gray-800 p-2 rounded">
                <strong>Temp password for <?php echo e(session('temp_user_email')); ?>:</strong>
                <span class="ml-2 font-mono"><?php echo e(session('temp_password')); ?></span>
                <p class="text-xs text-gray-300 mt-1">Make sure the user resets the password on first login.</p>
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>

<?php if(session('error')): ?>
    <div class="bg-red-600 text-white p-3 rounded mb-4">
        <?php echo e(session('error')); ?>

    </div>
<?php endif; ?>

<div class="flex justify-between items-center mb-6">
    <h1 class="text-2xl font-bold text-white"> Sacco Members</h1>
    <a href="<?php echo e(route('users.create')); ?>" 
       class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">
        + Add User
    </a>
</div>

<!-- 🔍 Search + Filter Bar -->
<form method="GET" action="<?php echo e(route('users.index')); ?>" 
      class="flex flex-wrap items-center justify-between bg-gray-800 p-4 rounded-lg shadow mb-6">

    <div class="flex flex-wrap items-center gap-3 w-full md:w-auto">
        <!-- Search box -->
        <div class="relative w-full md:w-72">
            <input type="text" 
                   name="search" 
                   value="<?php echo e(request('search')); ?>" 
                   placeholder="🔍 Search name, email or ID" 
                   class="w-full px-4 py-2 pl-10 bg-gray-700 border border-gray-600 text-gray-200 
                          placeholder-gray-400 rounded-lg focus:ring-2 focus:ring-blue-500 focus:outline-none">
            <svg xmlns="http://www.w3.org/2000/svg" 
                 class="absolute left-3 top-2.5 h-5 w-5 text-gray-400" 
                 fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                      d="M21 21l-4.35-4.35m0 0A7.5 7.5 0 1110.5 3a7.5 7.5 0 016.15 13.65z" />
            </svg>
        </div>

        <!-- Role filter -->
        <select name="role" 
                class="px-3 py-2 bg-gray-700 border border-gray-600 text-gray-200 rounded-lg 
                       focus:ring-2 focus:ring-blue-500 focus:outline-none">
            <option value="">All Roles</option>
            <option value="admin" <?php echo e(request('role') == 'admin' ? 'selected' : ''); ?>>Admin</option>
            <option value="member" <?php echo e(request('role') == 'member' ? 'selected' : ''); ?>>Member</option>
        </select>

        <!-- Submit -->
        <button class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg transition">
            Apply
        </button>
    </div>

    <!-- Reset -->
    <?php if(request('search') || request('role')): ?>
        <a href="<?php echo e(route('users.index')); ?>" 
           class="text-sm text-gray-400 hover:text-gray-200 transition">
           Reset Filters
        </a>
    <?php endif; ?>
</form>

<!-- 🧾 Users Table -->
<div class="overflow-x-auto bg-gray-900 rounded-lg shadow">
    <table class="min-w-full text-left border-collapse">
        <thead>
            <tr class="bg-blue-700 text-white">
                <th class="px-4 py-2">Member ID</th>
                <th class="px-4 py-2">Name</th>
                <th class="px-4 py-2">Email</th>
                <th class="px-4 py-2">Role</th>
                <th class="px-4 py-2">Status</th>
                <th class="px-4 py-2">Phone</th>
                <th class="px-4 py-2">Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="border-b border-gray-700 hover:bg-gray-800 transition">
                    <td class="px-4 py-2 text-blue-400 font-semibold">
                        <?php echo e($user->member_id ?? 'N/A'); ?>

                    </td>
                    <td class="px-4 py-2">
    <a href="<?php echo e(route('admin.users.show', $user->id)); ?>"
       class="text-blue-400 hover:text-blue-300 underline">
        <?php echo e($user->name); ?>

    </a>
</td>

                    <td class="px-4 py-2 text-gray-300"><?php echo e($user->email); ?></td>
                    <td class="px-4 py-2 capitalize text-gray-200"><?php echo e($user->role); ?></td>
                    <td class="px-4 py-2">
                        <?php if($user->status === 'active'): ?>
                            <span class="text-green-400 font-semibold">Active</span>
                        <?php elseif($user->status === 'pending'): ?>
                            <span class="text-yellow-400 font-semibold">Pending Approval</span>
                        <?php else: ?>
                            <span class="text-red-400 font-semibold">Inactive</span>
                        <?php endif; ?>
                    </td>
                    <td class="px-4 py-2 text-gray-300"><?php echo e($user->phone ?? 'N/A'); ?></td>
                    <td class="px-4 py-2">
                        <a href="<?php echo e(route('users.edit', $user->id)); ?>" 
                           class="text-blue-400 hover:underline">Edit</a> |
                       <div class="flex gap-2">
    <?php if($user->status !== 'active'): ?>
        <form method="POST" action="<?php echo e(route('users.status', [$user->id, 'active'])); ?>">
            <?php echo csrf_field(); ?>
            <button class="text-green-400 hover:underline">Activate</button>
        </form>
    <?php endif; ?>

    <?php if($user->status !== 'inactive'): ?>
        <form method="POST" action="<?php echo e(route('users.status', [$user->id, 'inactive'])); ?>">
            <?php echo csrf_field(); ?>
            <button class="text-red-400 hover:underline">Deactivate</button>
        </form>
    <?php endif; ?>
</div>

                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="text-center py-4 text-gray-400">
                        No users found.
                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- 📄 Pagination -->
<div class="mt-6 text-white">
    <?php echo e($users->links()); ?>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/users/index.blade.php ENDPATH**/ ?>