

<?php $__env->startSection('content'); ?>

<h1 class="text-3xl font-bold mb-6 text-white">Welcome, <?php echo e($user->name); ?></h1>

<div class="grid grid-cols-1 md:grid-cols-4 gap-6">

    <!-- PROFILE -->
    <div class="bg-gray-800 p-6 rounded-lg shadow md:col-span-1">
        <h2 class="text-xl font-semibold text-gray-200 mb-4">Your Profile</h2>

        <div class="flex flex-col items-center text-center">
            <img src="<?php echo e($user->photo ? asset('storage/photos/' . $user->photo) : 'https://ui-avatars.com/api/?name=' . urlencode($user->name)); ?>"
                class="w-24 h-24 rounded-full border border-gray-600 shadow">

            <h3 class="mt-3 text-lg text-white font-bold"><?php echo e($user->name); ?></h3>

            <p class="text-gray-400 text-sm"><?php echo e($user->email); ?></p>
            <p class="text-gray-400 text-sm"><?php echo e($user->phone ?? 'No phone added'); ?></p>

            <p class="mt-3 text-blue-300 font-semibold">
                Member ID: <?php echo e($user->member_id); ?>

            </p>
            <p>                    <a href="<?php echo e(route('member.insights')); ?>"
   class="mt-4 inline-block bg-blue-600 px-4 py-2 rounded hover:bg-blue-700 text-white">
    View Financial Insights →
</a></p>
        </div>
    </div>

    <!-- SUMMARY CARDS -->
    <div class="md:col-span-3 grid grid-cols-1 md:grid-cols-3 gap-6">

        <!-- SAVINGS -->
        <div class="bg-gray-800 p-6 rounded-lg shadow">
            <h2 class="text-xl font-semibold text-blue-300">Savings</h2>

            <p class="mt-3 text-gray-400">Total Deposited</p>
            <p class="text-2xl font-bold text-green-400">UGX <?php echo e(number_format($deposits)); ?></p>

            <p class="mt-3 text-gray-400">Total Withdrawn</p>
            <p class="text-2xl font-bold text-red-400">UGX <?php echo e(number_format($withdrawals)); ?></p>

            <hr class="my-4 border-gray-700">

            <p class="text-gray-300 text-sm">
                Net Savings:
                <span class="font-bold text-white">
                    UGX <?php echo e(number_format($deposits - $withdrawals)); ?>

                </span>
            </p>
        </div>

        <!-- LOAN STATUS -->
        <div class="bg-gray-800 p-6 rounded-lg shadow">
            <h2 class="text-xl font-semibold text-purple-300">Loan Status</h2>

            <?php if(!$activeLoan): ?>
                <p class="text-gray-400 mt-2">You currently have no active or approved loans.</p>

                <a href="<?php echo e(route('member.loans.apply')); ?>"
                   class="mt-4 inline-block bg-blue-600 px-4 py-2 rounded hover:bg-blue-700">
                    Apply for a Loan
                </a>

            <?php else: ?>
                <p class="mt-2 text-gray-400">Loan Type:</p>
                <p class="font-bold text-gray-200"><?php echo e($activeLoan->loanType->name); ?></p>

                <p class="mt-3 text-gray-400">Principal:</p>
                <p class="text-xl font-bold text-green-400">
                    UGX <?php echo e(number_format($activeLoan->principal)); ?>

                </p>

                <p class="mt-3 text-gray-400">Outstanding Balance:</p>
                <p class="text-xl font-bold text-yellow-300">
                    UGX <?php echo e(number_format($activeLoan->balance)); ?>

                </p>

                <?php if($nextRepayment): ?>
                    <hr class="my-4 border-gray-700">

                    <p class="text-gray-400">Next Installment Amount:</p>
                    <p class="text-xl font-bold text-blue-300">
                        UGX <?php echo e(number_format($nextRepayment['payment'])); ?>

                    </p>

                    <p class="mt-2 text-gray-400">Due On:</p>
                    <p class="font-bold text-gray-200">
                        <?php echo e(\Carbon\Carbon::parse($nextRepayment['due_date'])->format('d M Y')); ?>

                    </p>
                <?php endif; ?>
            <?php endif; ?>
        </div>

        <!-- UPCOMING SCHEDULE -->
        <div class="bg-gray-800 p-6 rounded-lg shadow">
            <h2 class="text-xl font-semibold text-yellow-300">Upcoming Payments</h2>

            <?php
                $upcoming = $loanSchedule->where('balance', '>', 0)->take(5);
            ?>

            <?php if(!$activeLoan || $upcoming->isEmpty()): ?>
                <p class="text-gray-400 mt-2">No scheduled repayments at the moment.</p>
            <?php else: ?>
                <ul class="mt-3 space-y-2">
                    <?php $__currentLoopData = $upcoming; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="p-2 bg-gray-700 rounded">
                            <p class="text-gray-300">
                                Amount:
                                <span class="font-bold text-green-300">
                                    UGX <?php echo e(number_format($item['payment'])); ?>

                                </span>
                            </p>
                            <p class="text-gray-300">
                                Due:
                                <span class="font-bold">
                                    <?php echo e(\Carbon\Carbon::parse($item['due_date'])->format('d M Y')); ?>

                                </span>
                            </p>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            <?php endif; ?>
        </div>

    </div>
</div>

<!-- ACCOUNTS -->
<div class="mt-8 bg-gray-800 p-6 rounded-lg shadow">
    <h2 class="text-xl font-semibold text-gray-200 mb-4">Your Accounts</h2>

    <?php if($accounts->isEmpty()): ?>
        <p class="text-gray-400">No accounts found under your profile.</p>
    <?php else: ?>
        <table class="w-full text-left text-gray-300">
            <thead class="bg-gray-700">
                <tr>
                    <th class="p-2">Account Number</th>
                    <th class="p-2">Type</th>
                    <th class="p-2">Status</th>
                    <th class="p-2">Balance</th>


                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="border-b border-gray-700">
                        <td class="p-2"><?php echo e($account->account_number); ?></td>
                        <td class="p-2"><?php echo e($account->type->name ?? 'N/A'); ?></td>
                        <td class="p-2 capitalize">
                            <span class="text-<?php echo e($account->status == 'active' ? 'green' : 'red'); ?>-400">
                                <?php echo e($account->status); ?>

                            </span>
                        </td>
                        <td class="p-2">UGX <?php echo e(number_format($account->current_balance)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>

<!-- RECENT TRANSACTIONS -->
<div class="mt-8 bg-gray-800 p-6 rounded-lg shadow">
    <h2 class="text-xl font-semibold text-gray-200 mb-4">Recent Transactions</h2>

    <?php if($recentTransactions->isEmpty()): ?>
        <p class="text-gray-400">You have no recent activity.</p>
    <?php else: ?>
        <table class="w-full text-left text-gray-300">
            <thead class="bg-gray-700">
                <tr>
                    <th class="p-2">Date</th>
                    <th class="p-2">Type</th>
                    <th class="p-2">Amount</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $recentTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="border-b border-gray-700">
                        <td class="p-2"><?php echo e($tx->created_at->format('d M Y')); ?></td>
                        <td class="p-2 capitalize"><?php echo e($tx->type); ?></td>
                        <td class="p-2">
                            <?php $color = $tx->type === 'deposit' ? 'green' : 'red'; ?>
                            <span class="text-<?php echo e($color); ?>-400">UGX <?php echo e(number_format($tx->amount)); ?></span>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.member', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/member/dashboard.blade.php ENDPATH**/ ?>