<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Hosanna Sacco</title>
    <?php echo app('Illuminate\Foundation\Vite')('resources/css/app.css'); ?>
</head>

<body class="bg-gray-900 text-gray-200 flex min-h-screen">

    <!-- Sidebar -->
    <!-- Sidebar -->
<aside class="w-64 bg-gray-800 text-white flex flex-col">
    <div class="p-6 text-center border-b border-gray-600">
        <h1 class="text-xl font-bold">HOSANNA SACCO</h1>
        <p class="text-sm">Admin Panel</p>
    </div>


    <nav class="flex-1 p-4 space-y-2">

    
    <a href="<?php echo e(route('admin.dashboard')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
        🏠 Dashboard
    </a>
     
    <div class="mt-4">
        <p class="text-xs uppercase text-blue-300">Polices & Shares</p>

        <a href="<?php echo e(route('admin.policies.index')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
            Policies
        </a>
        <a href="<?php echo e(route('admin.shares.index')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
            Shares
        </a>
    </div>

      
    <div class="mt-4">
        <p class="text-xs uppercase text-blue-300">Expenses </p>

        <a href="<?php echo e(route('admin.expenses.index')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
            Expenses 
        </a>
    </div>

    
<div class="mt-4">
    <p class="text-xs uppercase text-blue-300">Income</p>

      <a href="<?php echo e(route('admin.incomes.dashboard')); ?>"
       class="block py-2 px-3 rounded hover:bg-blue-700">
        📊 Income Dashboard
    </a>

    <a href="<?php echo e(route('admin.income_types.index')); ?>"
       class="block py-2 px-3 rounded hover:bg-blue-700">
        ➕  Income Types
    </a>

    <a href="<?php echo e(route('admin.incomes.index')); ?>"
       class="block py-2 px-3 rounded hover:bg-blue-700">
        📋 Income Records
    </a>

</div>


    
    <div class="mt-4">
        <p class="text-xs uppercase text-blue-300">Users</p>

        <a href="<?php echo e(route('admin.users.index')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
            📋 View Users
        </a>

        <a href="<?php echo e(route('admin.users.create')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
            ➕ Add User
        </a>
    </div>

    
    <div class="mt-4">
        <p class="text-xs uppercase text-blue-300">Account Types</p>

        <a href="<?php echo e(route('admin.account_types.index')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
            🧩 Account Types
        </a>
    </div>

    
    <div class="mt-4">
        <p class="text-xs uppercase text-blue-300">Accounts</p>

        <a href="<?php echo e(route('admin.accounts.index')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
            📊 View Accounts
        </a>

        <a href="<?php echo e(route('admin.accounts.create')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
            ➕ Create Account
        </a>

        <a href="<?php echo e(route('admin.transactions.index')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
            💳 Transactions
        </a>
    </div>

    
    <div class="mt-4">
        <p class="text-xs uppercase text-blue-300">Groups</p>

        <a href="<?php echo e(route('admin.groups.index')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
            👥 View Groups
        </a>

        <a href="<?php echo e(route('admin.groups.create')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
            ➕ Create Group
        </a>

        <a href="<?php echo e(route('admin.group_loans.index')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
            🗂️ Group Loans
        </a>
    </div>

    
    <div class="mt-4">
        <p class="text-xs uppercase text-blue-300">Loan Types</p>

        <a href="<?php echo e(route('admin.loan_types.index')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
            🗂️ Loan Types
        </a>
    </div>

    
    <div class="mt-4">
        <p class="text-xs uppercase text-blue-300">Loans</p>

        <?php if(auth()->user()->role === 'admin'): ?>
            <a href="<?php echo e(route('admin.loans.index')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
                📑 All Loans
            </a>
        <?php endif; ?>

        
<?php if(auth()->user()->role === 'loan_officer'): ?>
    <div class="mt-4">
        <p class="text-xs uppercase text-blue-300">Loan Officer</p>

        <a href="<?php echo e(route('loan_officer.loans.index')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
            📌 Pending & Approved Loans
        </a>
    </div>
<?php endif; ?>


        
        <?php if(auth()->user()->role === 'member'): ?>
            <a href="<?php echo e(route('member.loans.apply')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
                📝 Apply for Loan
            </a>

            <a href="<?php echo e(route('member.loans.index')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
                📚 My Loans
            </a>
        <?php endif; ?>
    </div>

    
    <a href="#" class="block py-2 px-3 rounded hover:bg-blue-700 mt-6">
        ⚙️ Settings
    </a>
</nav>

 
    
    <div class="p-4 border-t border-blue-700">
        <form action="<?php echo e(route('logout')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <button class="w-full text-left py-2 px-3 rounded hover:bg-blue-700">
                🚪 Logout
            </button>
        </form>
    </div>
</aside>
    <!-- Main Content -->
    <main class="flex-1 p-6">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\myproject\resources\views/layouts/admin.blade.php ENDPATH**/ ?>