

<?php $__env->startSection('content'); ?>
<div class="p-6 max-w-2xl mx-auto">
    <h2 class="text-2xl font-semibold text-gray-100 mb-4">Edit User</h2>

    <form action="<?php echo e(route('users.update', $user->id)); ?>" enctype="multipart/form-data" method="POST" class="space-y-4 bg-gray-800 p-6 rounded-lg shadow">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div>
            <label class="block text-sm text-gray-300">Name</label>
            <input type="text" name="name" value="<?php echo e($user->name); ?>" class="w-full p-2 rounded bg-gray-900 border border-gray-700 text-white" required>
        </div>

        <div>
            <label class="block text-sm text-gray-300">Phone</label>
            <input type="text" name="phone" value="<?php echo e($user->phone); ?>" class="w-full p-2 rounded bg-gray-900 border border-gray-700 text-white">
        </div>
        <div class="mb-4">
            <label class="block text-gray-300 mb-2">Profile Photo</label>
            <input type="file" name="photo"
                class="w-full text-white bg-gray-700 border border-gray-600 rounded px-3 py-2">
        </div>

        <div>
            <label class="block text-sm text-gray-300">Address</label>
            <input type="text" name="address" value="<?php echo e($user->address); ?>" class="w-full p-2 rounded bg-gray-900 border border-gray-700 text-white">
        </div>

        <div>
            <label class="block text-sm text-gray-300">National ID</label>
            <input type="text" name="national_id" value="<?php echo e($user->national_id); ?>" class="w-full p-2 rounded bg-gray-900 border border-gray-700 text-white">
        </div>

        <div>
            <label class="block text-sm text-gray-300">Role</label>
            <select name="role" class="w-full p-2 rounded bg-gray-900 border border-gray-700 text-white">
                <option value="member" <?php if($user->role == 'member'): echo 'selected'; endif; ?>>Member</option>
                <option value="admin" <?php if($user->role == 'admin'): echo 'selected'; endif; ?>>Admin</option>
                <option value="member" <?php if($user->role == 'loan_officer'): echo 'selected'; endif; ?>>Loan officer</option>
                <option value="admin" <?php if($user->role == 'accountant'): echo 'selected'; endif; ?>>Accountant</option>
            </select>
        </div>
        <button class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">Update User</button>
        <a href="<?php echo e(route('users.index')); ?>" class="text-gray-400 ml-4 hover:text-gray-300">Cancel</a>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/users/edit.blade.php ENDPATH**/ ?>