

<?php $__env->startSection('content'); ?>
<div class="p-6 text-gray-100">

    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">Share Purchases</h1>

        <form action="<?php echo e(route('admin.shares.index')); ?>" method="GET" class="flex gap-2">
            <input 
                type="text" 
                name="search"
                value="<?php echo e(request('search')); ?>"
                placeholder="Search member or admin..."
                class="px-3 py-2 bg-gray-800 border border-gray-700 rounded text-sm w-64"
            >
            <button class="px-4 py-2 bg-blue-600 hover:bg-blue-700 rounded text-white text-sm">
                Search
            </button>
        </form>
    </div>

    <div class="bg-gray-800 border border-gray-700 rounded shadow">
        <table class="w-full text-left text-sm">
            <thead class="bg-gray-700 text-gray-300 uppercase text-xs">
                <tr>
                    <th class="p-3">Date</th>
                    <th class="p-3">Member</th>
                    <th class="p-3">Shares</th>
                    <th class="p-3">Amount (UGX)</th>
                    <th class="p-3">Price/Share</th>
                    <th class="p-3">Recorded By</th>
                </tr>
            </thead>

            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $shares; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="border-b border-gray-700 hover:bg-gray-750">
                    <td class="p-3"><?php echo e($s->created_at->format('d M Y')); ?></td>
                    <td class="p-3 font-medium text-blue-400">
                        <a href="<?php echo e(route('admin.users.show', $s->member->id)); ?>">
                            <?php echo e($s->member->name); ?>

                        </a>
                    </td>
                    <td class="p-3"><?php echo e(number_format($s->shares)); ?></td>
                    <td class="p-3 text-green-400 font-semibold">UGX <?php echo e(number_format($s->amount)); ?></td>
                    <td class="p-3">UGX <?php echo e(number_format($s->price_per_share)); ?></td>
                    <td class="p-3 text-gray-300"><?php echo e($s->admin->name); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="text-center p-4 text-gray-400">
                        No share purchases found.
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        <?php echo e($shares->links()); ?>

    </div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/shares/index.blade.php ENDPATH**/ ?>