<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Loan Officer Panel - Hosanna Sacco</title>
    <?php echo app('Illuminate\Foundation\Vite')('resources/css/app.css'); ?>
</head>

<body class="bg-gray-900 text-gray-200 flex min-h-screen">

    <!-- SIDEBAR -->
    <aside class="w-64 bg-gray-800 text-white flex flex-col">
        
        <div class="p-6 text-center border-b border-gray-700">
            <h1 class="text-xl font-bold">HOSANNA SACCO</h1>
            <p class="text-sm">Loan Officer Panel</p>
        </div>

        <nav class="flex-1 p-4 space-y-2">

            
            <a href="<?php echo e(route('loan_officer.loans.index')); ?>"
               class="block py-2 px-3 rounded hover:bg-blue-700">
                📊 Dashboard
            </a>

            
            <div class="mt-4">
                <p class="text-xs uppercase text-blue-300">Loan Operations</p>

                <a href="<?php echo e(route('loan_officer.loans.index')); ?>"
                   class="block py-2 px-3 rounded hover:bg-blue-700">
                    📄 Loan Approvals
                </a>
            </div>

        </nav>

        
        <div class="p-4 border-t border-gray-700">
            <form action="<?php echo e(route('logout')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <button class="w-full text-left py-2 px-3 rounded hover:bg-blue-700">
                    🚪 Logout
                </button>
            </form>
        </div>

    </aside>

    <!-- MAIN CONTENT -->
    <main class="flex-1 p-6">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\myproject\resources\views/layouts/loan_officer.blade.php ENDPATH**/ ?>