<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\MemberController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AccountTypeController;
use App\Http\Controllers\AccountController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\LoanTypeController;
use App\Http\Controllers\LoanController;
use App\Http\Controllers\GroupLoanController;
use App\Http\Controllers\GroupLoanRepaymentController;
use App\Http\Controllers\PolicyController;
use App\Http\Controllers\AdminShareController;
use App\Http\Controllers\IncomeTypeController;
use App\Http\Controllers\IncomeController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// 🏠 Public Landing Page
Route::get('/', function () {
    return view('landing'); // points to resources/views/landing.blade.php
});

// 🧭 Protected Dashboard (only for logged-in users)
Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])
        ->name('dashboard');
});

// 🔐 Auth Routes (Login, Register, etc.)
require __DIR__.'/auth.php';



// Member loans
Route::middleware(['auth'])->group(function () {
    Route::get('/loans', [\App\Http\Controllers\LoanController::class, 'myLoans'])->name('member.loans.index');
    Route::get('/loans/apply', [\App\Http\Controllers\LoanController::class, 'apply'])->name('member.loans.apply');
    Route::post('/loans', [\App\Http\Controllers\LoanController::class, 'store'])->name('member.loans.store');
    Route::get('/loans/{loan}', [\App\Http\Controllers\LoanController::class, 'show'])->name('member.loans.show');
    Route::post('/loans/{loan}/repay', [\App\Http\Controllers\LoanController::class, 'repay'])->name('member.loans.repay');
});


//protecting admin aoppss
Route::middleware(['auth', 'admin'])->prefix('admin')->group(function () {
    Route::get('/', [App\Http\Controllers\AdminController::class, 'index'])->name('admin.dashboard');
    Route::resource('users', App\Http\Controllers\UserController::class);
    
// admin policies (explicit)
Route::get('/policies', [\App\Http\Controllers\PolicyController::class, 'adminIndex'])
    ->name('admin.policies.index');

Route::get('/policies/create', [\App\Http\Controllers\PolicyController::class, 'create'])
    ->name('admin.policies.create');

Route::post('/policies', [\App\Http\Controllers\PolicyController::class, 'store'])
    ->name('admin.policies.store');

// EDIT / UPDATE / DELETE that your blade expects
Route::get('/policies/{policy}/edit', [\App\Http\Controllers\PolicyController::class, 'edit'])
    ->name('admin.policies.edit');

Route::put('/policies/{policy}', [\App\Http\Controllers\PolicyController::class, 'update'])
    ->name('admin.policies.update');

    

Route::delete('/policies/{policy}', [\App\Http\Controllers\PolicyController::class, 'destroy'])
    ->name('admin.policies.destroy');




    Route::post('/users/{user}/status/{status}', [UserController::class, 'updateStatus'])
    ->name('users.status');
    // USER DETAILS PAGE
    Route::get('/admin/users', [UserController::class, 'index'])
    ->name('admin.users.index');
    Route::get('/admin/users/create', [UserController::class, 'create'])->name('admin.users.create');
    Route::get('/admin/users/{user}', [UserController::class, 'show'])
    ->name('admin.users.show');

    Route::post('/admin/users/{user}/reset-password',
    [UserController::class, 'resetPassword'])
    ->name('admin.users.reset-password');


    // Account Types Module (Admin Only)
    Route::get('/account-types', [AccountTypeController::class, 'index'])->name('admin.account_types.index');
    Route::get('/account-types/create', [AccountTypeController::class, 'create'])->name('admin.account_types.create');
    Route::post('/account-types', [AccountTypeController::class, 'store'])->name('admin.account_types.store');
    // EDIT
    Route::get('/account-types/{type}/edit', [AccountTypeController::class, 'edit'])->name('admin.account_types.edit');
    // UPDATE
    Route::put('/account-types/{type}', [AccountTypeController::class, 'update'])->name('admin.account_types.update');
    // DELETE
    Route::delete('/account-types/{type}', [AccountTypeController::class, 'destroy'])->name('admin.account_types.destroy');
    // ACTIVATE / DEACTIVATE
    Route::post('/account-types/{type}/toggle-status', [AccountTypeController::class, 'toggleStatus'])
        ->name('admin.account_types.toggle_status');

    // Accounts Module
    Route::get('/accounts', [AccountController::class, 'index'])->name('admin.accounts.index');
    Route::get('/accounts/create', [AccountController::class, 'create'])->name('admin.accounts.create');
    Route::post('/accounts', [AccountController::class, 'store'])->name('admin.accounts.store');
    Route::get('/accounts/{account}/edit', [AccountController::class, 'edit'])->name('admin.accounts.edit');
    Route::put('/accounts/{account}', [AccountController::class, 'update'])->name('admin.accounts.update');
    Route::post('/accounts/{account}/toggle-status', [AccountController::class, 'toggleStatus'])->name('admin.accounts.toggle_status');
    Route::delete('/accounts/{account}', [AccountController::class, 'destroy'])->name('admin.accounts.destroy');
    Route::get('/accounts/export/csv', [AccountController::class, 'exportCsv'])
    ->name('admin.accounts.export.csv');
    Route::get('/accounts/export/excel', [AccountController::class, 'exportExcel'])
     ->name('admin.accounts.export.excel');
     Route::get('/accounts/{account}', [AccountController::class, 'show'])
    ->name('admin.accounts.show');

    // Transactions
    Route::get('/accounts/{account}/transactions', [TransactionController::class, 'index'])
        ->name('admin.accounts.transactions');
    Route::post('/accounts/{account}/deposit', [TransactionController::class, 'deposit'])
        ->name('admin.accounts.deposit');
    Route::post('/accounts/{account}/withdraw', [TransactionController::class, 'withdraw'])
        ->name('admin.accounts.withdraw');


    ////
Route::get('/shares', [AdminShareController::class, 'index'])
    ->name('admin.shares.index');

Route::get('/shares/{user}/create', [AdminShareController::class, 'create'])
    ->name('admin.shares.create');

Route::post('/shares/{user}', [AdminShareController::class, 'store'])
    ->name('admin.shares.store');



        //receipt sprint 
        Route::get('transactions/{id}/receipt', [TransactionController::class, 'receipt'])
    ->name('admin.transactions.receipt');


        // GLOBAL TRANSACTIONS LIST PAGE
Route::get('/transactions', [TransactionController::class, 'index'])
    ->name('admin.transactions.index');

// EXPORT ROUTES
Route::get('/transactions/export/csv', [TransactionController::class, 'exportCsv'])
    ->name('admin.transactions.export.csv');

Route::get('/transactions/export/excel', [TransactionController::class, 'exportExcel'])
    ->name('admin.transactions.export.excel');

//loan types creat
Route::get('/loan_types', [LoanTypeController::class, 'index'])
    ->name('admin.loan_types.index');

Route::get('/loan_types/create', [LoanTypeController::class, 'create'])
    ->name('admin.loan_types.create');

Route::post('/loan_types', [LoanTypeController::class, 'store'])
    ->name('admin.loan_types.store');

Route::get('/loan_types/{loanType}/edit', [LoanTypeController::class, 'edit'])
    ->name('admin.loan_types.edit');

Route::put('/loan_types/{loanType}', [LoanTypeController::class, 'update'])
    ->name('admin.loan_types.update');

Route::delete('/loan_types/{loanType}', [LoanTypeController::class, 'destroy'])
    ->name('admin.loan_types.destroy');

    Route::get('/expenses', [App\Http\Controllers\Admin\ExpenseController::class, 'index'])
    ->name('admin.expenses.index');

Route::get('/expenses/create', [App\Http\Controllers\Admin\ExpenseController::class, 'create'])
    ->name('admin.expenses.create');

Route::post('/expenses', [App\Http\Controllers\Admin\ExpenseController::class, 'store'])
    ->name('admin.expenses.store');

Route::get('/expenses/{expense}/edit', [App\Http\Controllers\Admin\ExpenseController::class, 'edit'])
    ->name('admin.expenses.edit');

Route::put('/expenses/{expense}', [App\Http\Controllers\Admin\ExpenseController::class, 'update'])
    ->name('admin.expenses.update');

//expensese routes
Route::get('/expenses', [App\Http\Controllers\Admin\ExpenseController::class, 'index'])
    ->name('admin.expenses.index');

Route::get('/expenses/create', [App\Http\Controllers\Admin\ExpenseController::class, 'create'])
    ->name('admin.expenses.create');

Route::post('/expenses', [App\Http\Controllers\Admin\ExpenseController::class, 'store'])
    ->name('admin.expenses.store');

Route::get('/expenses/{expense}/edit', [App\Http\Controllers\Admin\ExpenseController::class, 'edit'])
    ->name('admin.expenses.edit');

Route::put('/expenses/{expense}', [App\Http\Controllers\Admin\ExpenseController::class, 'update'])
    ->name('admin.expenses.update');


// SACCO-wide ledger CSV
Route::get('/transactions/export/financial-csv', [TransactionController::class, 'exportFinancialCsv'])
    ->name('admin.transactions.export.financial_csv');

// Member PDF statement (grouped per account)
Route::get('/users/{user}/statement', [TransactionController::class, 'memberStatementPdf'])
    ->name('admin.users.statement');


    // Groups
Route::resource('groups', App\Http\Controllers\GroupController::class, [
    'as' => 'admin'
])->except(['show']); // we'll define show separately to have nice URL

Route::get('/groups/{group}', [App\Http\Controllers\GroupController::class, 'show'])->name('admin.groups.show');

// member actions
Route::post('/groups/{group}/members', [App\Http\Controllers\GroupController::class, 'addMember'])
    ->name('admin.groups.members.add');

Route::delete('/groups/{group}/members/{member}', [App\Http\Controllers\GroupController::class, 'removeMember'])
    ->name('admin.groups.members.remove');

Route::post('/groups/{group}/members/{member}/toggle', [App\Http\Controllers\GroupController::class, 'toggleMemberStatus'])
    ->name('admin.groups.members.toggle');

// INCOME TYPES (CRUD)
    Route::resource('income_types', IncomeTypeController::class)
        ->names('admin.income_types')
        ->except(['show']);

    // INCOMES
    Route::get('incomes', [IncomeController::class, 'index'])->name('admin.incomes.index');
    Route::get('incomes/create', [IncomeController::class, 'create'])->name('admin.incomes.create');
    Route::post('incomes', [IncomeController::class, 'store'])->name('admin.incomes.store');
    Route::get('incomes/create', [IncomeController::class, 'create'])->name('admin.incomes.create');
    Route::get('incomes/{income}/edit', [IncomeController::class, 'edit'])->name('admin.incomes.edit');
    Route::put('incomes/{income}', [IncomeController::class, 'update'])->name('admin.incomes.update');

    // Income Exports
Route::get('incomes/export/csv', [IncomeController::class, 'exportCsv'])
    ->name('admin.incomes.export.csv');

Route::get('incomes/export/pdf', [IncomeController::class, 'exportPdf'])
    ->name('admin.incomes.export.pdf');

        Route::get('/incomes/dashboard', [IncomeController::class, 'dashboard'])
        ->name('admin.incomes.dashboard');



    Route::get('/loans', [LoanController::class, 'adminIndex'])->name('admin.loans.index');
    Route::get('/loans/{loan}', [LoanController::class, 'show'])->name('admin.loans.show');
    Route::post('/loans/{loan}/approve', [LoanController::class, 'approve'])->name('admin.loans.approve');
    Route::post('/loans/{loan}/reject', [LoanController::class, 'reject'])->name('admin.loans.reject');
    Route::post('/loans/{loan}/disburse', [LoanController::class, 'disburse'])->name('admin.loans.disburse');
    Route::post('/loans/{loan}/repay', [LoanController::class, 'repay'])->name('admin.loans.repay');
    Route::post('/loans/{loan}/close', [LoanController::class, 'close'])
    ->name('admin.loans.close');


    // Create Loan (Admin)
    Route::get('admin/groups/{group}/loans/create', 
        [GroupLoanController::class, 'create'])
        ->name('admin.group_loans.create');
        // View list of group loans
Route::get('admin/group-loans', [GroupLoanController::class, 'index'])
    ->name('admin.group_loans.index');


    Route::post('admin/groups/{group}/loans', 
        [GroupLoanController::class, 'store'])
        ->name('admin.group_loans.store');

Route::get('admin/group-loans/{loan}', 
    [GroupLoanController::class, 'show'])
    ->name('admin.group_loans.show');

    // Approve loan
    Route::post('admin/loans/{loan}/approve', 
        [GroupLoanController::class, 'approve'])
        ->name('admin.group_loans.approve');

    // Disburse Loan
    Route::post('admin/loans/{loan}/disburse', 
        [GroupLoanController::class, 'disburse'])
        ->name('admin.group_loans.disburse');

  

        // Add repayment to a loan
Route::post('admin/loans/{loan}/repayments', 
    [GroupLoanRepaymentController::class, 'store'])
    ->name('admin.group_loan_repayments.store');

// Print repayment receipt
Route::get('admin/repayments/{repayment}/receipt', 
    [GroupLoanRepaymentController::class, 'receipt'])
    ->name('admin.repayments.receipt'); 
});



Route::middleware(['auth', 'verified'])->prefix('member')->group(function () {

    Route::get('/dashboard', [MemberController::class, 'dashboard'])
        ->name('member.dashboard');

    // Show Apply Form
    Route::get('/loans/apply', [LoanController::class, 'apply'])
        ->name('member.loans.apply');

    // Submit Loan Application
    Route::post('/loans/apply', [LoanController::class, 'store'])
        ->name('member.loans.submit');

    // Member loan list
    Route::get('/loans', [LoanController::class, 'memberLoans'])
        ->name('member.loans.index');

    // MEMBER submits repayment
Route::post('/loans/{loan}/repay', 
    [LoanController::class, 'repay']
)->name('member.loans.repay');

Route::get('/member/insights', [MemberController::class, 'insights'])
    ->name('member.insights');
  
Route::get('/member/loan-statement/{loan}', [MemberController::class, 'loanStatement'])
    ->name('member.loan.statement');

Route::get('/policies', [PolicyController::class, 'memberIndex'])
    ->name('member.policies.index');

// Member: accept a policy (POST)
Route::post('/policies/{policy}/agree', [PolicyController::class, 'agree'])
    ->name('member.policies.agree');

    Route::get('/member/policies/{policy}/pdf', [PolicyController::class, 'memberPdf'])
    ->name('member.policies.pdf');


Route::get('/member/statement', [MemberController::class, 'statement'])
    ->name('member.statement');

Route::get('/member/statement/export/pdf', [MemberController::class, 'statementPdf'])
    ->name('member.statement.pdf');




});





Route::middleware(['auth'])->group(function () {

    Route::get('members/{member}/group-loans', 
        [GroupLoanController::class, 'indexForMember'])
        ->name('members.group_loans');

});


/**
 * ================================================================
 *  LOAN OFFICER ROUTES
 *  - Loan approvals / rejections
 *  - Loan disbursements
 *  - Loan closing
 *  - View pending loans
 *  ================================================================
 */
Route::middleware(['auth', 'role:loan_officer,admin'])
    ->prefix('loan-officer')
    ->name('loan_officer.')
    ->group(function () {

        Route::get('/loans', [LoanController::class, 'loanOfficerIndex'])
            ->name('loans.index');

        Route::get('/loans/{loan}', [LoanController::class, 'show'])
            ->name('loans.show');

        Route::post('/loans/{loan}/approve', [LoanController::class, 'approve'])
            ->name('loans.approve');

        Route::post('/loans/{loan}/reject', [LoanController::class, 'reject'])
            ->name('loans.reject');

        Route::post('/loans/{loan}/disburse', [LoanController::class, 'disburse'])
            ->name('loans.disburse');

        Route::post('/loans/{loan}/close', [LoanController::class, 'close'])
            ->name('loans.close');
});














