<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Welcome | Magezi Munyo Sacco</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="antialiased bg-gray-50 text-gray-800">

    <!-- Hero Section -->
    <section class="bg-gradient-to-b from-blue-800 to-blue-600 text-white">
        <div class="max-w-7xl mx-auto px-6 py-20 text-center">
            <div class="mb-8">
                <img src="{{ asset('images/hosanna-logo.png') }}" alt="Hosanna Sacco Logo" class="mx-auto w-32 h-auto mb-6">
            </div>
            <h1 class="text-4xl sm:text-5xl font-extrabold mb-4">Hossana Community Dev' Sacco</h1>
            <p class="text-lg text-blue-100 mb-8">Your trusted savings and credit cooperative partner. Build a secure financial future together.</p>

            <div class="space-x-4">
                <a href="{{ route('register') }}" class="px-6 py-3 bg-white text-blue-700 font-semibold rounded-lg shadow hover:bg-blue-50 transition">
                    Get Started
                </a>
                <a href="{{ route('login') }}" class="px-6 py-3 bg-transparent border border-blue-100 text-white font-semibold rounded-lg hover:bg-blue-700 transition">
                    Sign In
                </a>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="py-16 bg-gray-50">
        <div class="max-w-6xl mx-auto text-center">
            <div class="grid md:grid-cols-3 gap-10 px-6">
                <div>
                    <div class="flex justify-center mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-10 h-10 text-blue-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h11M9 21V3m12 12h-8m-4 8V9" />
                        </svg>
                    </div>
                    <h3 class="font-semibold text-lg mb-2">Track Your Savings</h3>
                    <p class="text-gray-600">Monitor your monthly and yearly savings with detailed analytics and insights.</p>
                </div>

                <div>
                    <div class="flex justify-center mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-10 h-10 text-green-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                        </svg>
                    </div>
                    <h3 class="font-semibold text-lg mb-2">Community Driven</h3>
                    <p class="text-gray-600">Join a community of savers working together towards financial independence.</p>
                </div>

                <div>
                    <div class="flex justify-center mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-10 h-10 text-emerald-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 11c0 1.104-.896 2-2 2s-2-.896-2-2 .896-2 2-2 2 .896 2 2z" />
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 2a10 10 0 100 20 10 10 0 000-20z" />
                        </svg>
                    </div>
                    <h3 class="font-semibold text-lg mb-2">Secure & Reliable</h3>
                    <p class="text-gray-600">Your financial data is protected with enterprise-grade security measures.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="border-t border-gray-200 py-6 text-center text-sm text-gray-500">
        © {{ date('Y') }}Hossana Community Dev' Sacco All rights reserved.
    </footer>

</body>
</html>
