@extends('layouts.member')

@section('content')

<h1 class="text-3xl font-bold text-white mb-6">Financial Insights</h1>

<div class="grid grid-cols-1 md:grid-cols-2 gap-6">

    <!-- Savings Trend -->
    <div class="bg-gray-800 p-6 rounded-lg shadow">
        <h2 class="text-xl font-semibold text-blue-300 mb-3">Savings Trend (Monthly)</h2>
        <canvas id="savingsTrendChart"></canvas>
    </div>

    <!-- Loan Balance Curve -->
    <div class="bg-gray-800 p-6 rounded-lg shadow">
        <h2 class="text-xl font-semibold text-purple-300 mb-3">Loan Balance Decline Curve</h2>
        @if($loanSchedule->isEmpty())
            <p class="text-gray-400">You have no loan schedule available.</p>
        @else
            <canvas id="loanBalanceChart"></canvas>
        @endif
    </div>

 


    <!-- Deposits vs Withdrawals -->
<div class="bg-gray-800 p-6 rounded-lg shadow md:col-span-2">
    <h2 class="text-xl font-semibold text-yellow-300 mb-3">Deposits vs Withdrawals</h2>

    <div class="flex justify-center">
        <div class="w-[300px] h-[300px]">
            <canvas id="pieChart"></canvas>
        </div>
    </div>
</div>


</div>


<!-- Chart.js CDN -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
    /* ============================================================
     * 1. Savings Trend Chart (Deposits & Withdrawals)
     * ============================================================ */
    const savingsMonths = @json($monthlyDeposits->keys());
    const depositsData = @json($monthlyDeposits->values());
    const withdrawalsData = @json($monthlyWithdrawals->values());

    new Chart(document.getElementById('savingsTrendChart'), {
        type: 'line',
        data: {
            labels: savingsMonths,
            datasets: [
                {
                    label: 'Deposits',
                    data: depositsData,
                    borderWidth: 2
                },
                {
                    label: 'Withdrawals',
                    data: withdrawalsData,
                    borderWidth: 2
                }
            ]
        }
    });


    /* ============================================================
     * 2. Loan Balance Decline Curve
     * ============================================================ */
    @if($loanSchedule->isNotEmpty())
        const loanPeriods = @json($loanSchedule->pluck('period'));
        const loanBalances = @json($loanSchedule->pluck('balance'));

        new Chart(document.getElementById('loanBalanceChart'), {
            type: 'line',
            data: {
                labels: loanPeriods,
                datasets: [{
                    label: 'Remaining Loan Balance',
                    data: loanBalances,
                    borderWidth: 2
                }]
            }
        });
    @endif


    /* ============================================================
     * 3. Deposits vs Withdrawals Pie Chart
     * ============================================================ */
    const totalDeposits = {{ $totalDeposits }};
    const totalWithdrawals = {{ $totalWithdrawals }};

    new Chart(document.getElementById('pieChart'), {
        type: 'pie',
        data: {
            labels: ['Deposits', 'Withdrawals'],
            datasets: [{
                data: [totalDeposits, totalWithdrawals],
                borderWidth: 1
            }]
        }
    });
</script>

@endsection
