@extends('layouts.member')

@section('content')

<h1 class="text-3xl font-bold mb-6 text-white">Welcome, {{ $user->name }}</h1>

<div class="grid grid-cols-1 md:grid-cols-4 gap-6">

    <!-- PROFILE -->
    <div class="bg-gray-800 p-6 rounded-lg shadow md:col-span-1">
        <h2 class="text-xl font-semibold text-gray-200 mb-4">Your Profile</h2>

        <div class="flex flex-col items-center text-center">
            <img src="{{ $user->photo ? asset('storage/photos/' . $user->photo) : 'https://ui-avatars.com/api/?name=' . urlencode($user->name) }}"
                class="w-24 h-24 rounded-full border border-gray-600 shadow">

            <h3 class="mt-3 text-lg text-white font-bold">{{ $user->name }}</h3>

            <p class="text-gray-400 text-sm">{{ $user->email }}</p>
            <p class="text-gray-400 text-sm">{{ $user->phone ?? 'No phone added' }}</p>

            <p class="mt-3 text-blue-300 font-semibold">
                Member ID: {{ $user->member_id }}
            </p>
            <p>                    <a href="{{ route('member.insights') }}"
   class="mt-4 inline-block bg-blue-600 px-4 py-2 rounded hover:bg-blue-700 text-white">
    View Financial Insights →
</a></p>
        </div>
    </div>

    <!-- SUMMARY CARDS -->
    <div class="md:col-span-3 grid grid-cols-1 md:grid-cols-3 gap-6">

        <!-- SAVINGS -->
        <div class="bg-gray-800 p-6 rounded-lg shadow">
            <h2 class="text-xl font-semibold text-blue-300">Savings</h2>

            <p class="mt-3 text-gray-400">Total Deposited</p>
            <p class="text-2xl font-bold text-green-400">UGX {{ number_format($deposits) }}</p>

            <p class="mt-3 text-gray-400">Total Withdrawn</p>
            <p class="text-2xl font-bold text-red-400">UGX {{ number_format($withdrawals) }}</p>

            <hr class="my-4 border-gray-700">

            <p class="text-gray-300 text-sm">
                Net Savings:
                <span class="font-bold text-white">
                    UGX {{ number_format($deposits - $withdrawals) }}
                </span>
            </p>
        </div>

        <!-- LOAN STATUS -->
        <div class="bg-gray-800 p-6 rounded-lg shadow">
            <h2 class="text-xl font-semibold text-purple-300">Loan Status</h2>

            @if(!$activeLoan)
                <p class="text-gray-400 mt-2">You currently have no active or approved loans.</p>

                <a href="{{ route('member.loans.apply') }}"
                   class="mt-4 inline-block bg-blue-600 px-4 py-2 rounded hover:bg-blue-700">
                    Apply for a Loan
                </a>

            @else
                <p class="mt-2 text-gray-400">Loan Type:</p>
                <p class="font-bold text-gray-200">{{ $activeLoan->loanType->name }}</p>

                <p class="mt-3 text-gray-400">Principal:</p>
                <p class="text-xl font-bold text-green-400">
                    UGX {{ number_format($activeLoan->principal) }}
                </p>

                <p class="mt-3 text-gray-400">Outstanding Balance:</p>
                <p class="text-xl font-bold text-yellow-300">
                    UGX {{ number_format($activeLoan->balance) }}
                </p>

                @if($nextRepayment)
                    <hr class="my-4 border-gray-700">

                    <p class="text-gray-400">Next Installment Amount:</p>
                    <p class="text-xl font-bold text-blue-300">
                        UGX {{ number_format($nextRepayment['payment']) }}
                    </p>

                    <p class="mt-2 text-gray-400">Due On:</p>
                    <p class="font-bold text-gray-200">
                        {{ \Carbon\Carbon::parse($nextRepayment['due_date'])->format('d M Y') }}
                    </p>
                @endif
            @endif
        </div>

        <!-- UPCOMING SCHEDULE -->
        <div class="bg-gray-800 p-6 rounded-lg shadow">
            <h2 class="text-xl font-semibold text-yellow-300">Upcoming Payments</h2>

            @php
                $upcoming = $loanSchedule->where('balance', '>', 0)->take(5);
            @endphp

            @if(!$activeLoan || $upcoming->isEmpty())
                <p class="text-gray-400 mt-2">No scheduled repayments at the moment.</p>
            @else
                <ul class="mt-3 space-y-2">
                    @foreach($upcoming as $item)
                        <li class="p-2 bg-gray-700 rounded">
                            <p class="text-gray-300">
                                Amount:
                                <span class="font-bold text-green-300">
                                    UGX {{ number_format($item['payment']) }}
                                </span>
                            </p>
                            <p class="text-gray-300">
                                Due:
                                <span class="font-bold">
                                    {{ \Carbon\Carbon::parse($item['due_date'])->format('d M Y') }}
                                </span>
                            </p>
                        </li>
                    @endforeach
                </ul>
            @endif
        </div>

    </div>
</div>

<!-- ACCOUNTS -->
<div class="mt-8 bg-gray-800 p-6 rounded-lg shadow">
    <h2 class="text-xl font-semibold text-gray-200 mb-4">Your Accounts</h2>

    @if($accounts->isEmpty())
        <p class="text-gray-400">No accounts found under your profile.</p>
    @else
        <table class="w-full text-left text-gray-300">
            <thead class="bg-gray-700">
                <tr>
                    <th class="p-2">Account Number</th>
                    <th class="p-2">Type</th>
                    <th class="p-2">Status</th>
                    <th class="p-2">Balance</th>


                </tr>
            </thead>
            <tbody>
                @foreach($accounts as $account)
                    <tr class="border-b border-gray-700">
                        <td class="p-2">{{ $account->account_number }}</td>
                        <td class="p-2">{{ $account->type->name ?? 'N/A' }}</td>
                        <td class="p-2 capitalize">
                            <span class="text-{{ $account->status == 'active' ? 'green' : 'red' }}-400">
                                {{ $account->status }}
                            </span>
                        </td>
                        <td class="p-2">UGX {{ number_format($account->current_balance) }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif
</div>

<!-- RECENT TRANSACTIONS -->
<div class="mt-8 bg-gray-800 p-6 rounded-lg shadow">
    <h2 class="text-xl font-semibold text-gray-200 mb-4">Recent Transactions</h2>

    @if($recentTransactions->isEmpty())
        <p class="text-gray-400">You have no recent activity.</p>
    @else
        <table class="w-full text-left text-gray-300">
            <thead class="bg-gray-700">
                <tr>
                    <th class="p-2">Date</th>
                    <th class="p-2">Type</th>
                    <th class="p-2">Amount</th>
                </tr>
            </thead>
            <tbody>
                @foreach($recentTransactions as $tx)
                    <tr class="border-b border-gray-700">
                        <td class="p-2">{{ $tx->created_at->format('d M Y') }}</td>
                        <td class="p-2 capitalize">{{ $tx->type }}</td>
                        <td class="p-2">
                            @php $color = $tx->type === 'deposit' ? 'green' : 'red'; @endphp
                            <span class="text-{{ $color }}-400">UGX {{ number_format($tx->amount) }}</span>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif
</div>

@endsection
