@extends('layouts.admin')

@section('content')
<div class="p-6 space-y-6">
    <div class="flex justify-between items-center">
        <h2 class="text-2xl font-semibold text-gray-100">Loan #{{ $loan->id }}</h2>
        <div>
            <a href="{{ route('member.loans.index') }}" class="px-3 py-2 bg-gray-600 rounded text-white">Back</a>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <div class="bg-gray-800 p-4 rounded">
            <h3 class="font-semibold text-gray-100">Summary</h3>
            <p class="text-gray-300 mt-2">Type: {{ ucfirst($loan->loan_type) }}</p>
            <p class="text-gray-300">Requested: UGX {{ number_format($loan->amount) }}</p>
            <p class="text-gray-300">Term: {{ $loan->term_months ?? '-' }} months</p>
            <p class="text-gray-300">Status: {{ ucfirst($loan->status) }}</p>
            <p class="text-gray-300">Applied: {{ $loan->created_at->format('Y-m-d') }}</p>
            @if($loan->approved_at)
                <p class="text-gray-300">Approved: {{ $loan->approved_at->format('Y-m-d') }} by {{ $loan->approver->name ?? 'N/A' }}</p>
            @endif
            @if($loan->disbursed_at)
                <p class="text-gray-300">Disbursed: {{ $loan->disbursed_at->format('Y-m-d') }}</p>
            @endif
        </div>

        <div class="bg-gray-800 p-4 rounded lg:col-span-2">
            <h3 class="font-semibold text-gray-100">Details & Actions</h3>

            {{-- Asset info --}}
            @if($loan->loan_type === 'asset')
                <div class="mt-3">
                    <p class="text-gray-300">Asset Value: {{ $loan->asset_value ? 'UGX '.number_format($loan->asset_value) : '-' }}</p>
                    <p class="text-gray-300">Allowed (50% of asset): {{ $loan->asset_value ? 'UGX '.number_format($loan->asset_value * 0.5) : '-' }}</p>
                </div>
            @endif

            {{-- Group info --}}
            @if($loan->loan_type === 'group' && $loan->group)
                <div class="mt-3">
                    <p class="text-gray-300">Group: {{ $loan->group->name }}</p>
                    <p class="text-gray-300">Active members: {{ $loan->group->activeMembersCount() }}</p>
                </div>
            @endif

            {{-- Purpose --}}
            <div class="mt-3">
                <h4 class="text-gray-200 font-medium">Purpose</h4>
                <p class="text-gray-300 mt-1">{{ $loan->purpose ?? '-' }}</p>
            </div>

            {{-- Repayments --}}
            <div class="mt-4">
                <h4 class="text-gray-200 font-medium">Repayments</h4>
                <div class="mt-2">
                    @if($loan->repayments->count())
                        <table class="w-full text-left text-sm text-gray-300">
                            <thead class="bg-gray-700">
                                <tr>
                                    <th class="p-2">Date</th>
                                    <th>Amount</th>
                                    <th>Recorded By</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($loan->repayments as $r)
                                    <tr class="border-t border-gray-700">
                                        <td class="p-2">{{ $r->created_at->format('Y-m-d') }}</td>
                                        <td>UGX {{ number_format($r->amount) }}</td>
                                        <td>{{ $r->admin->name ?? '-' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        <p class="text-gray-400">No repayments recorded yet.</p>
                    @endif
                </div>

                {{-- Repay form (member) --}}
                @if(auth()->user()->id === $loan->user_id && $loan->status === 'disbursed')
                    <form action="{{ route('member.loans.repay', $loan) }}" method="POST" class="mt-3 grid grid-cols-1 md:grid-cols-3 gap-2">
                        @csrf
                        <input name="amount" placeholder="Amount" class="px-2 py-1 rounded bg-gray-700" required />
                        <select name="account_id" class="px-2 py-1 rounded bg-gray-700">
                            <option value="">From account (optional)</option>
                            @foreach(\App\Models\Account::where('user_id', $loan->user_id)->get() as $acct)
                                <option value="{{ $acct->id }}">{{ $acct->account_number }} (UGX {{ number_format($acct->balance) }})</option>
                            @endforeach
                        </select>
                        <div class="flex gap-2">
                            <button class="px-3 py-1 bg-green-600 rounded">Pay</button>
                        </div>
                    </form>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
