@extends('layouts.admin')

@section('content')
<div class="p-6 space-y-6">

    <h2 class="text-2xl font-semibold text-gray-100">Loan Applications</h2>

    <!-- Filter Box -->
    <div class="bg-gray-800 p-4 rounded shadow">
        <form method="GET" class="mb-4 flex gap-2">
            <select name="status" class="px-3 py-2 bg-gray-700 rounded text-gray-200">
                <option value="">All statuses</option>
                <option value="pending"   {{ request('status')=='pending' ? 'selected' : '' }}>Pending</option>
                <option value="approved"  {{ request('status')=='approved' ? 'selected' : '' }}>Approved</option>
                <option value="disbursed" {{ request('status')=='disbursed' ? 'selected' : '' }}>Disbursed</option>
                <option value="rejected"  {{ request('status')=='rejected' ? 'selected' : '' }}>Rejected</option>
                <option value="closed"    {{ request('status')=='closed' ? 'selected' : '' }}>Closed</option>
            </select>

            <button class="px-3 py-2 bg-blue-600 rounded text-white">Filter</button>
        </form>

        <!-- Table -->
        <table class="w-full text-left text-gray-200">
            <thead class="text-gray-400 bg-gray-700">
                <tr>
                    <th class="p-2">Date</th>
                    <th>Member</th>
                    <th>Loan Type</th>
                    <th>Principal</th>
                    <th>Total Payable</th>
                    <th>Status</th>
                    <th class="text-right">Actions</th>
                </tr>
            </thead>

            <tbody>
                @forelse($loans as $loan)
                <tr class="border-t border-gray-700 hover:bg-gray-700">

                    <td class="p-2">
                        {{ $loan->created_at->format('Y-m-d') }}
                    </td>

                    <td class="p-2">
                        {{ $loan->user->name ?? 'Unknown' }} <br>
                        <span class="text-xs text-gray-400">{{ $loan->user->member_id ?? '' }}</span>
                    </td>

                    <td class="p-2">
                        {{ $loan->loanType->name ?? 'N/A' }}
                    </td>

                    <td class="p-2">
                        UGX {{ number_format($loan->principal) }}
                    </td>

                    <td class="p-2">
                        UGX {{ number_format($loan->total_payable) }}
                    </td>

                    <td class="p-2">
                        <span class="px-2 py-1 rounded text-xs 
                            @if($loan->status=='pending') bg-yellow-600 
                            @elseif($loan->status=='approved') bg-blue-600 
                            @elseif($loan->status=='disbursed') bg-purple-600 
                            @elseif($loan->status=='rejected') bg-red-600 
                            @elseif($loan->status=='closed') bg-green-600 
                            @else bg-gray-600 @endif">
                            {{ ucfirst($loan->status) }}
                        </span>
                    </td>

                    <td class="p-2 text-right space-x-2">

                        <!-- View Button -->
                        <a href="{{ route('admin.loans.show', $loan->id) }}"
                           class="text-blue-400 hover:underline">
                           View
                        </a>

                        <!-- Approve -->
                        @if($loan->status === 'pending')
                        <form action="{{ route('admin.loans.approve', $loan->id) }}" 
                              method="POST" class="inline">
                            @csrf
                            <button class="text-green-400 hover:underline">Approve</button>
                        </form>

                        <!-- Reject -->
                        <form action="{{ route('admin.loans.reject', $loan->id) }}" 
                              method="POST" class="inline ml-2">
                            @csrf
                            <button class="text-red-400 hover:underline">Reject</button>
                        </form>
                        @endif

                        <!-- Disburse -->
                        @if($loan->status === 'approved')
                        <form action="{{ route('admin.loans.disburse', $loan->id) }}" 
                              method="POST" class="inline ml-2">
                            @csrf
                            <button class="text-purple-400 hover:underline">Disburse</button>
                        </form>
                        @endif

                    </td>
                </tr>

                @empty
                <tr>
                    <td colspan="7" class="py-6 text-center text-gray-400">No loans found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>

        <div class="mt-4">
            {{ $loans->links() }}
        </div>
    </div>
</div>
@endsection
