@extends('layouts.admin')

@section('content')
<div class="p-6 bg-gray-900 text-gray-200 min-h-screen">

    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">All Transactions</h1>

        <div class="flex gap-2">

                    {{-- NEW: SACCO-WIDE FINANCIAL STATEMENT CSV --}}
         <a href="{{ route('admin.transactions.export.financial_csv', request()->query()) }}"
       class="flex items-center gap-2 bg-yellow-600 hover:bg-yellow-700 px-3 py-2 rounded text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                d="M9 17v-6h13m-4 4l4-4m0 0l-4-4"/>
        </svg>
         Txn Statement (CSV)
    </a>
           
             <a href="{{ route('admin.transactions.export.csv', request()->query()) }}"
       class="flex items-center gap-2 bg-green-600 hover:bg-green-700 px-3 py-2 rounded text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                d="M4 16v2a2 2 0 002 2h12a2 2 0 002-2v-2M4 12l4 4m0 0l4-4m-4 4V4"/>
        </svg>
        Export CSV
    </a>

            <a href="{{ route('admin.transactions.export.excel', request()->query()) }}"
               class="bg-blue-600 hover:bg-blue-700 px-3 py-2 rounded text-white">Export Excel</a>

        </div>
    </div>

    {{-- Filters panel --}}
    <form method="GET" action="{{ route('admin.transactions.index') }}" class="bg-gray-800 rounded p-4 mb-6">
        <div class="grid grid-cols-1 md:grid-cols-6 gap-3">
            <div class="md:col-span-2">
                <input name="search" value="{{ request('search') }}" placeholder="Search account, member, admin, description"
                       class="w-full px-3 py-2 rounded bg-gray-700 border border-gray-600" />
            </div>

            <div>
                <select name="type" class="w-full px-3 py-2 rounded bg-gray-700 border border-gray-600">
                    <option value="">All types</option>
                    <option value="deposit" {{ request('type')=='deposit' ? 'selected' : '' }}>Deposit</option>
                    <option value="withdrawal" {{ request('type')=='withdrawal' ? 'selected' : '' }}>Withdrawal</option>
                </select>
            </div>

            <div>
                <select name="account" class="w-full px-3 py-2 rounded bg-gray-700 border border-gray-600">
                    <option value="">All accounts</option>
                    @foreach($accountsList as $acct)
                        <option value="{{ $acct->id }}" {{ (string)request('account') === (string)$acct->id ? 'selected' : '' }}>
                            {{ $acct->account_number }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div>
                <select name="member" class="w-full px-3 py-2 rounded bg-gray-700 border border-gray-600">
                    <option value="">All members</option>
                    @foreach($membersList as $m)
                        <option value="{{ $m->id }}" {{ (string)request('member') === (string)$m->id ? 'selected' : '' }}>
                            {{ $m->name }} ({{ $m->member_id }})
                        </option>
                    @endforeach
                </select>
            </div>

            <div>
                <input type="date" name="date_from" value="{{ request('date_from') ?: \Carbon\Carbon::now()->subDays(30)->toDateString() }}"
                       class="w-full px-3 py-2 rounded bg-gray-700 border border-gray-600" />
            </div>

            <div>
                <input type="date" name="date_to" value="{{ request('date_to') ?: \Carbon\Carbon::now()->toDateString() }}"
                       class="w-full px-3 py-2 rounded bg-gray-700 border border-gray-600" />
            </div>
        </div>

        <div class="mt-3 flex gap-2">
            <button type="submit" class="px-4 py-2 bg-blue-600 hover:bg-blue-700 rounded text-white">Apply</button>
            <a href="{{ route('admin.transactions.index') }}" class="px-4 py-2 bg-gray-600 hover:bg-gray-700 rounded text-white">Reset</a>
        </div>
    </form>

    {{-- Totals summary --}}
    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
        <div class="bg-gray-800 p-4 rounded shadow">
            <p class="text-sm text-gray-400">Total Deposits</p>
            <p class="text-2xl font-bold text-green-400">UGX {{ number_format($depositTotal, 2) }}</p>
        </div>
        <div class="bg-gray-800 p-4 rounded shadow">
            <p class="text-sm text-gray-400">Total Withdrawals</p>
            <p class="text-2xl font-bold text-red-400">UGX {{ number_format($withdrawTotal, 2) }}</p>
        </div>
        <div class="bg-gray-800 p-4 rounded shadow">
            <p class="text-sm text-gray-400">Net Movement</p>
            <p class="text-2xl font-bold text-white">UGX {{ number_format($net, 2) }}</p>
        </div>
    </div>

    {{-- Transactions table --}}
    <div class="bg-gray-800 p-4 rounded shadow">
        <table class="w-full text-left">
            <thead>
                <tr class="text-gray-400 border-b border-gray-700">
                    <th class="py-2">Date</th>
                    <th>Account</th>
                    <th>Member</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Before</th>
                    <th>After</th>
                    <th>Description</th>
                    <th>Admin</th>
                </tr>
            </thead>
            <tbody class="text-gray-300">
                @forelse($transactions as $tx)
                    <tr class="border-b border-gray-700">
                        <td class="py-2">{{ $tx->created_at->format('Y-m-d H:i') }}</td>
                        <td>
                            <a href="{{ route('admin.accounts.show', $tx->account_id) }}" class="text-blue-400 hover:underline">
                                {{ $tx->account->account_number ?? 'N/A' }}
                            </a>
                        </td>
                        <td>{{ $tx->account->user->name ?? 'N/A' }}</td>
                        <td class="capitalize">{{ $tx->type }}</td>
                        <td class="text-blue-300">UGX {{ number_format($tx->amount, 2) }}</td>
                        <td>{{ number_format($tx->balance_before, 2) }}</td>
                        <td>{{ number_format($tx->balance_after, 2) }}</td>
                        <td>{{ $tx->description ?? '-' }}</td>
                        <td>{{ $tx->admin->name ?? 'N/A' }}</td>
                    </tr>
                @empty
                    <tr><td colspan="9" class="py-4 text-center text-gray-400">No transactions found for these filters.</td></tr>
                @endforelse
            </tbody>
        </table>

        <div class="mt-4">
            {{ $transactions->links() }}
        </div>
    </div>
</div>
@endsection
