@extends('layouts.admin')

@section('content')
<h1 class="text-2xl font-bold mb-4">Policies</h1>

<a href="{{ route('admin.policies.create') }}"
   class="bg-blue-600 px-4 py-2 text-white rounded mb-4 inline-block">
    Create Policy
</a>

<table class="w-full bg-gray-800 text-left text-gray-200 rounded">
    <tr class="bg-gray-700">
        <th class="p-2">Title</th>
        <th class="p-2">Version</th>
        <th class="p-2">Active</th>
        <th class="p-2">Actions</th>
    </tr>

    @foreach($policies as $policy)
        <tr class="border-b border-gray-700">
            <td class="p-2">{{ $policy->title }}</td>
            <td class="p-2">{{ $policy->version }}</td>
            <td class="p-2">{{ $policy->is_active ? 'Yes' : 'No' }}</td>
            <td class="p-2">
                <a href="{{ route('admin.policies.edit', $policy) }}" class="text-blue-400 mr-2">Edit</a>

                <form action="{{ route('admin.policies.destroy', $policy) }}" method="POST" class="inline">
                    @csrf @method('DELETE')
                    <button onclick="return confirm('Delete this policy?')" class="text-red-400">Delete</button>
                </form>
            </td>
        </tr>
    @endforeach
</table>
@endsection
