@extends('layouts.admin')

@section('content')
<div class="p-6">
    <div class="flex justify-between items-center mb-4">
        <h2 class="text-2xl font-bold text-white">Loan Types</h2>
        <a href="{{ route('admin.loan_types.create') }}" class="px-4 py-2 bg-indigo-600 rounded text-white">New Loan Type</a>
    </div>

    @if(session('success')) <div class="mb-3 p-3 bg-green-600 text-white">{{ session('success') }}</div> @endif

    <div class="bg-gray-800 p-4 rounded">
        <table class="w-full text-left text-gray-200">
            <thead class="text-gray-400">
                <tr>
                    <th>Name</th>
                    <th>Interest %</th>
                    <th>Duration (m)</th>
                    <th>Group?</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($types as $t)
                <tr class="border-t border-gray-700">
                    <td class="py-2">{{ $t->name }}</td>
                    <td>{{ $t->interest_rate }}</td>
                    <td>{{ $t->duration_months }}</td>
                    <td>{{ $t->is_group_loan ? 'Yes' : 'No' }}</td>
                    <td>{{ ucfirst($t->status) }}</td>
                    <td>
                        <a href="{{ route('admin.loan_types.edit', $t->id) }}" class="text-yellow-400">Edit</a>
                        <form action="{{ route('admin.loan_types.destroy', $t->id) }}" method="POST" class="inline ml-2" onsubmit="return confirm('Delete?');">
                            @csrf @method('DELETE')
                            <button class="text-red-400">Delete</button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr><td colspan="6" class="py-4 text-gray-400">No loan types yet.</td></tr>
                @endforelse
            </tbody>
        </table>

        <div class="mt-4">{{ $types->links() }}</div>
    </div>
</div>
@endsection
