@extends('layouts.admin')

@section('content')
<div class="p-6 text-gray-100">

    <div class="flex justify-between mb-4">
        <h1 class="text-2xl font-bold">Income Records</h1>
        <a href="{{ route('admin.incomes.create') }}"
           class="bg-blue-600 px-4 py-2 rounded hover:bg-blue-700">+ Add Income</a>
    </div>

    <!-- ================= FILTER BAR ================= -->
    <form method="GET" action="{{ route('admin.incomes.index') }}" class="bg-gray-800 p-4 rounded mb-6">

        <div class="grid grid-cols-1 md:grid-cols-6 gap-4">

            <!-- Search -->
            <div class="md:col-span-2">
                <input type="text" name="search" placeholder="Search description, amount, member..."
                       value="{{ request('search') }}"
                       class="w-full px-3 py-2 bg-gray-700 rounded border border-gray-600">
            </div>

            <!-- Income Type -->
            <div>
                <select name="income_type_id" class="w-full px-3 py-2 bg-gray-700 rounded border border-gray-600">
                    <option value="">All Types</option>
                    @foreach($incomeTypes as $type)
                        <option value="{{ $type->id }}" 
                            {{ request('income_type_id') == $type->id ? 'selected' : '' }}>
                            {{ $type->name }}
                        </option>
                    @endforeach
                </select>
            </div>

            <!-- Payment Method -->
            <div>
                <select name="payment_method" class="w-full px-3 py-2 bg-gray-700 rounded border border-gray-600">
                    <option value="">All Payments</option>
                    <option value="cash"         {{ request('payment_method')=='cash' ? 'selected' : '' }}>Cash</option>
                    <option value="mobile_money" {{ request('payment_method')=='mobile_money' ? 'selected' : '' }}>Mobile Money</option>
                    <option value="bank"         {{ request('payment_method')=='bank' ? 'selected' : '' }}>Bank</option>
                </select>
            </div>

            <!-- Member -->
            <div>
                <select name="member_id" class="w-full px-3 py-2 bg-gray-700 rounded border border-gray-600">
                    <option value="">All Members</option>
                    @foreach($members as $mem)
                        <option value="{{ $mem->id }}"
                            {{ request('member_id') == $mem->id ? 'selected' : '' }}>
                            {{ $mem->name }} ({{ $mem->member_id }})
                        </option>
                    @endforeach
                </select>
            </div>

            <!-- Date From -->
            <div>
                <input type="date" name="date_from" value="{{ request('date_from') }}"
                       class="w-full px-3 py-2 bg-gray-700 rounded border border-gray-600">
            </div>

            <!-- Date To -->
            <div>
                <input type="date" name="date_to" value="{{ request('date_to') }}"
                       class="w-full px-3 py-2 bg-gray-700 rounded border border-gray-600">
            </div>
        </div>

        <!-- Buttons -->
        <div class="flex justify-end mt-4 gap-3">
            <a href="{{ route('admin.incomes.index') }}"
               class="px-4 py-2 bg-gray-600 rounded hover:bg-gray-500">Reset</a>

            <button class="px-4 py-2 bg-blue-600 rounded hover:bg-blue-700">Apply</button>
        </div>

    </form>

    <div class="flex gap-3 mb-4">
    <a href="{{ route('admin.incomes.export.csv', request()->query()) }}"
       class="bg-green-600 px-4 py-2 rounded hover:bg-green-700">
        📄 Export CSV
    </a>

    <a href="{{ route('admin.incomes.export.pdf', request()->query()) }}"
       class="bg-red-600 px-4 py-2 rounded hover:bg-red-700">
        🧾 Export PDF
    </a>
</div>

    <!-- ================= END FILTER BAR ================= -->



    <!-- ================= TABLE ================= -->
    <table class="w-full bg-gray-800 text-left rounded overflow-hidden">
        <thead class="bg-gray-700 text-gray-300">
            <tr>
                <th class="p-3">Receipt</th>
                <th class="p-3">Type</th>
                <th class="p-3">Member</th>
                <th class="p-3">Amount</th>
                <th class="p-3">Payment</th>
                <th class="p-3">Date</th>
                <th class="p-3">Recorded By</th>
                <th class="p-3">Action</th>
            </tr>
        </thead>

        <tbody>
            @forelse($incomes as $inc)
            <tr class="border-b border-gray-700">
                <td class="p-3">{{ $inc->receipt_no }}</td>
                <td class="p-3">{{ $inc->type->name }}</td>
                <td class="p-3">{{ $inc->member->name ?? '—' }}</td>
                <td class="p-3 text-green-400">UGX {{ number_format($inc->amount) }}</td>
                <td class="p-3">{{ ucfirst(str_replace('_', ' ', $inc->payment_method)) }}</td>
                <td class="p-3">{{ $inc->income_date }}</td>
                <td class="p-3">{{ $inc->admin->name }}</td>
                <td class="p-3">
                    <a href="{{ route('admin.incomes.edit', $inc) }}" 
                       class="text-blue-400 hover:underline">Edit</a>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="8" class="text-center p-5 text-gray-400">
                    No income records found.
                </td>
            </tr>
            @endforelse
        </tbody>
    </table>

    <div class="mt-4">
        {{ $incomes->links() }}
    </div>

</div>
@endsection
