@extends('layouts.admin')

@section('content')
<div class="p-6 text-gray-100 max-w-3xl">

    <h1 class="text-2xl font-bold mb-4">Edit Income</h1>

    <form action="{{ route('admin.incomes.update', $income->id) }}" 
          method="POST" class="space-y-4 bg-gray-800 p-6 rounded">

        @csrf
        @method('PUT')

        {{-- Income Type --}}
        <div>
            <label class="text-sm">Income Type</label>
            <select name="income_type_id" class="w-full bg-gray-700 px-3 py-2 rounded" required>
                @foreach($incomeTypes as $type)
                    <option value="{{ $type->id }}"
                        {{ $income->income_type_id == $type->id ? 'selected' : '' }}>
                        {{ $type->name }}
                    </option>
                @endforeach
            </select>
        </div>

        {{-- Member (Optional) --}}
        <div>
            <label class="text-sm">Member (Optional)</label>
            <select name="member_id" class="w-full bg-gray-700 px-3 py-2 rounded">
                <option value="">— None —</option>
                @foreach($members as $member)
                    <option value="{{ $member->id }}"
                        {{ $income->member_id == $member->id ? 'selected' : '' }}>
                        {{ $member->name }} ({{ $member->member_id }})
                    </option>
                @endforeach
            </select>
        </div>

        {{-- Deposit To Account --}}
        <div>
            <label class="text-sm">Deposit Into Account</label>
            <select name="account_id" class="w-full bg-gray-700 px-3 py-2 rounded" required>
                <option value="">-- Select Account --</option>

                @foreach($accounts as $account)
                    <option value="{{ $account->id }}"
                        {{ $income->account_id == $account->id ? 'selected' : '' }}>
                        {{ $account->account_number }} — (UGX {{ number_format($account->balance,0) }})
                    </option>
                @endforeach
            </select>
        </div>

        {{-- Payment Method --}}
        <div>
            <label class="text-sm">Payment Method</label>
            <select name="payment_method" class="w-full bg-gray-700 px-3 py-2 rounded" required>
                @foreach(['Cash', 'Mobile Money', 'Bank'] as $method)
                    <option value="{{ $method }}"
                        {{ $income->payment_method == $method ? 'selected' : '' }}>
                        {{ $method }}
                    </option>
                @endforeach
            </select>
        </div>

        {{-- Amount --}}
        <div>
            <label class="text-sm">Amount (UGX)</label>
            <input type="number" step="0.01" name="amount"
                   value="{{ $income->amount }}"
                   class="w-full bg-gray-700 px-3 py-2 rounded" required>
        </div>

        {{-- Income Date --}}
        <div>
            <label class="text-sm">Income Date</label>
            <input type="date" name="income_date"
                   value="{{ $income->income_date }}"
                   class="w-full bg-gray-700 px-3 py-2 rounded" required>
        </div>

        {{-- Description --}}
        <div>
            <label class="text-sm">Description</label>
            <textarea name="description" rows="3"
                      class="w-full bg-gray-700 px-3 py-2 rounded">{{ $income->description }}</textarea>
        </div>

        <button class="bg-blue-600 px-4 py-2 rounded hover:bg-blue-700">Update Income</button>
    </form>

</div>
@endsection
