@extends('layouts.admin')

@section('content')
<div class="p-6 text-gray-100 max-w-3xl">

    <h1 class="text-2xl font-bold mb-4">Record Income</h1>

<form action="{{ route('admin.incomes.store') }}" method="POST"
      class="space-y-4 bg-gray-800 p-6 rounded">
    @csrf

    <div>
        <label class="text-sm">Income Type</label>
        <select name="income_type_id" class="w-full bg-gray-700 px-3 py-2 rounded">
            @foreach($incomeTypes as $type)
                <option value="{{ $type->id }}">{{ $type->name }}</option>
            @endforeach
        </select>
    </div>

    <div>
        <label class="text-sm">Member (Optional)</label>
        <select name="member_id" class="w-full bg-gray-700 px-3 py-2 rounded">
            <option value="">— None —</option>
            @foreach($members as $member)
                <option value="{{ $member->id }}">{{ $member->name }} ({{ $member->member_id }})</option>
            @endforeach
        </select>
    </div>

    <div>
        <label class="text-sm">Deposit Into Account</label>
<select name="account_id" class="w-full bg-gray-700 px-3 py-2 rounded" required>
    <option value="">-- Select Account --</option>

    @foreach($accounts as $account)
        <option value="{{ $account->id }}">
            {{ $account->account_number }} 
            @if($account->balance !== null)
                — (UGX {{ number_format($account->balance, 0) }})
            @endif
        </option>
    @endforeach
</select>

    </div>

    <div>
        <label class="text-sm">Payment Method</label>
        <select name="payment_method" class="w-full bg-gray-700 px-3 py-2 rounded">
            <option value="cash">Cash</option>
            <option value="mobile_money">Mobile Money</option>
            <option value="bank">Bank</option>
        </select>
    </div>

    <div>
        <label class="text-sm">Amount (UGX)</label>
        <input type="number" name="amount" class="w-full bg-gray-700 px-3 py-2 rounded" required>
    </div>

    <div>
        <label class="text-sm">Income Date</label>
        <input type="date" name="income_date" class="w-full bg-gray-700 px-3 py-2 rounded" required>
    </div>

    <div>
        <label class="text-sm">Description</label>
        <textarea name="description" class="w-full bg-gray-700 px-3 py-2 rounded" rows="3"></textarea>
    </div>

    <button class="bg-blue-600 px-4 py-2 rounded hover:bg-blue-700">Save</button>
</form>

</div>
@endsection
