@extends('layouts.admin')

@section('content')
<div class="p-6">
    <div class="flex justify-between items-center mb-4">
        <div>
            <h2 class="text-2xl font-bold text-white">{{ $group->name }}</h2>
            <p class="text-gray-400">Status: {{ ucfirst($group->status) }}</p>
        </div>
        <div class="space-x-2">
            <a href="{{ route('admin.groups.index') }}" class="px-3 py-2 bg-gray-600 rounded text-white">Back</a>
            <a href="{{ route('admin.groups.edit', $group->id) }}" class="px-3 py-2 bg-yellow-600 rounded text-white">Edit</a>
            <a href="{{ route('admin.group_loans.create', $group->id) }}" class="px-3 py-2 bg-blue-600 rounded text-white">Add Group loan</a>
        </div>
    </div>

    @if(session('success')) <div class="mb-3 p-3 bg-green-600 text-white">{{ session('success') }}</div> @endif
    @if(session('error')) <div class="mb-3 p-3 bg-red-600 text-white">{{ session('error') }}</div> @endif

    <div class="bg-gray-800 p-4 rounded mb-6">
        <h3 class="text-lg font-semibold text-white mb-3">Members ({{ $group->activeMembersCount() }} active)</h3>

        <table class="w-full text-left text-gray-300">
            <thead class="bg-gray-700 text-gray-100">
                <tr>
                    <th class="py-2 px-3">Name</th>
                    <th class="py-2 px-3">Phone</th>
                    <th class="py-2 px-3">Status</th>
                    <th class="py-2 px-3">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($group->members as $member)
                    <tr class="border-t border-gray-700">
                        <td class="py-2 px-3">{{ $member->user->name ?? 'N/A' }}</td>
                        <td class="py-2 px-3">{{ $member->user->phone ?? 'N/A' }}</td>
                        <td class="py-2 px-3">{{ ucfirst($member->status) }}</td>
                        <td class="py-2 px-3">
                            <form action="{{ route('admin.groups.members.toggle', [$group->id, $member->id]) }}" method="POST" class="inline">
                                @csrf
                                <button class="text-yellow-400">{{ $member->status=='active' ? 'Deactivate' : 'Activate' }}</button>
                            </form>

                            <form action="{{ route('admin.groups.members.remove', [$group->id, $member->id]) }}" method="POST" class="inline" onsubmit="return confirm('Remove member?');">
                                @csrf @method('DELETE')
                                <button class="text-red-400 ml-3">Remove</button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr><td colspan="4" class="py-4 text-gray-400">No members yet.</td></tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="bg-gray-800 p-4 rounded">
        <h3 class="text-lg font-semibold text-white mb-3">Add Member</h3>

        <form action="{{ route('admin.groups.members.add', $group->id) }}" method="POST" class="grid grid-cols-1 md:grid-cols-3 gap-3">
            @csrf
            <select name="user_id" class="p-2 rounded bg-gray-700 text-white">
                <option value="">Select member to add</option>
                @foreach($eligible as $u)
                    <option value="{{ $u->id }}">{{ $u->name }} ({{ $u->member_id ?? 'MBR' }})</option>
                @endforeach
            </select>
            <div class="md:col-span-2">
                <button class="px-4 py-2 bg-green-600 rounded text-white">Add Member</button>
            </div>
        </form>
    </div>
</div>
@endsection
