@extends('layouts.admin')

@section('content')

<div class="p-6 text-gray-200">

    <!-- PAGE TITLE -->
    <h1 class="text-3xl font-bold mb-6">
        Group Loan — #{{ $loan->id }}

        <span class="ml-3 px-3 py-1 rounded text-sm
            @if($loan->status == 'pending') bg-yellow-600
            @elseif($loan->status == 'approved') bg-blue-600
            @elseif($loan->status == 'active') bg-purple-600
            @elseif($loan->status == 'completed') bg-green-600
            @endif">
            {{ ucfirst($loan->status) }}
        </span>
    </h1>

    <!-- GRID -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">

        <!-- LOAN SUMMARY -->
        <div class="col-span-2 bg-gray-800 p-6 rounded-lg border border-gray-700 shadow">
            <h2 class="text-xl font-bold text-blue-300 mb-4">Loan Summary</h2>

            <div class="grid grid-cols-2 gap-4 text-gray-300">

                <p><strong>Group:</strong><br>{{ $loan->group->name }}</p>

                <p><strong>Principal:</strong><br>
                    UGX {{ number_format($loan->principal) }}
                </p>

                <p><strong>Interest Rate:</strong><br>{{ $loan->interest_rate }}%</p>

                <p><strong>Loan Period:</strong><br>
                    {{ $loan->loan_period_months }} Months
                </p>

                <p><strong>Balance:</strong><br>
                    <span class="text-yellow-300 font-bold">
                        UGX {{ number_format($loan->balance) }}
                    </span>
                </p>

                <p><strong>Created On:</strong><br>
                    {{ $loan->created_at->format('d M Y') }}
                </p>

                @if($loan->approved_at)
                <p><strong>Approved On:</strong><br>
                    {{ \Carbon\Carbon::parse($loan->approved_at)->format('d M Y') }}
                </p>
                @endif

                @if($loan->disbursed_at)
                <p><strong>Disbursed On:</strong><br>
                    {{ \Carbon\Carbon::parse($loan->disbursed_at)->format('d M Y') }}
                </p>
                @endif

            </div>
        </div>

        <!-- GROUP MEMBERS -->
        <div class="bg-gray-800 p-6 rounded-lg border border-gray-700 shadow">
            <h2 class="text-xl font-bold text-green-300 mb-4">Group Members</h2>

           @foreach($loan->group->users as $m)

            <div class="mb-3 p-3 bg-gray-900 rounded border border-gray-700">
                <p class="font-semibold text-white">{{ $m->name }}</p>
                <p class="text-sm text-gray-400">{{ $m->email }}</p>
                <p class="text-sm text-gray-400">{{ $m->phone }}</p>
            </div>
            @endforeach
        </div>

    </div>


    <!-- ADMIN ACTIONS -->
    <div class="bg-gray-800 p-6 rounded-lg border border-gray-700 shadow mt-8">
        <h2 class="text-xl font-bold text-purple-300 mb-4">Admin Actions</h2>

        <div class="flex flex-wrap gap-4">

            @if($loan->status === 'pending')
                <form action="{{ route('admin.group_loans.approve', $loan->id) }}" method="POST">
                    @csrf
                    <button class="px-4 py-2 bg-blue-600 hover:bg-blue-700 rounded text-white">
                        Approve Loan
                    </button>
                </form>
            @endif

            @if($loan->status === 'approved')
                <form action="{{ route('admin.group_loans.disburse', $loan->id) }}" method="POST">
                    @csrf
                    <button class="px-4 py-2 bg-purple-600 hover:bg-purple-700 rounded text-white">
                        Disburse Loan
                    </button>
                </form>
            @endif

            @if(in_array($loan->status, ['active', 'disbursed']))
                <button class="px-4 py-2 bg-green-600 hover:bg-green-700 rounded text-white"
                        onclick="document.getElementById('repayModal').showModal()">
                    Record Repayment
                </button>
            @endif

        </div>
    </div>


    <!-- REPAYMENT HISTORY -->
    <div class="bg-gray-800 p-6 rounded-lg border border-gray-700 shadow mt-8">
        <h2 class="text-xl font-bold text-yellow-300 mb-4">Repayment History</h2>

        <table class="w-full text-left text-gray-300">
            <thead class="bg-gray-700">
                <tr>
                    <th class="p-2">Date</th>
                    <th class="p-2">Member</th>
                    <th class="p-2">Amount</th>
                    <th class="p-2">Receipt</th>
                </tr>
            </thead>
            <tbody>

                @forelse($loan->repayments as $rep)
                <tr class="border-b border-gray-700">
                    <td class="p-2">{{ $rep->payment_date }}</td>
                    <td class="p-2">{{ $rep->member->name }}</td>
                    <td class="p-2 text-green-400">UGX {{ number_format($rep->amount) }}</td>
                    <td class="p-2">
                        <a href="{{ route('admin.repayments.receipt', $rep->id) }}"
                           class="text-blue-400 hover:text-blue-300">Print</a>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="4" class="p-3 text-center text-gray-500">
                        No repayments recorded yet.
                    </td>
                </tr>
                @endforelse

            </tbody>
        </table>
    </div>

</div>


<!-- REPAYMENT MODAL -->
<!-- REPAYMENT MODAL -->
<dialog id="repayModal" class="bg-gray-800 p-6 rounded shadow-lg text-gray-200 w-96 border border-gray-700">

    <h3 class="text-xl font-bold mb-4">Record Repayment</h3>

    <form action="{{ route('admin.group_loan_repayments.store', $loan->id) }}" method="POST">
        @csrf

        <!-- SELECT MEMBER PAYING -->
        <label class="block text-gray-300 mb-1">Member Paying</label>
        <select name="member_id"
                class="w-full p-2 mb-4 bg-gray-700 rounded border border-gray-600 text-white" required>
            <option value="">-- Select Member --</option>
            @foreach($loan->group->users as $member)
                <option value="{{ $member->id }}">{{ $member->name }}</option>
            @endforeach
        </select>

        <!-- AMOUNT -->
        <label class="block text-gray-300 mb-1">Amount</label>
        <input type="number" name="amount"
               class="w-full p-2 mb-4 bg-gray-700 rounded border border-gray-600 text-white"
               placeholder="Enter amount" required>

        <!-- PAYMENT DATE -->
        <label class="block text-gray-300 mb-1">Payment Date</label>
        <input type="date" name="payment_date"
               class="w-full p-2 mb-4 bg-gray-700 rounded border border-gray-600 text-white"
               required>

        <!-- NOTES -->
        <label class="block text-gray-300 mb-1">Notes (optional)</label>
        <textarea name="notes" rows="2"
                  class="w-full p-2 bg-gray-700 rounded border border-gray-600 text-white"></textarea>

        <div class="flex justify-end gap-3 mt-4">
            <button type="button" onclick="repayModal.close()"
                    class="px-3 py-1 bg-gray-600 rounded hover:bg-gray-500">
                Cancel
            </button>

            <button class="px-3 py-1 bg-green-600 rounded hover:bg-green-700">
                Save Repayment
            </button>
        </div>

    </form>

</dialog>

@endsection
