@extends('layouts.admin')

@section('content')
<div class="p-6 text-gray-100 max-w-3xl">

    <h1 class="text-2xl font-bold mb-4">Record Expense</h1>

    <form action="{{ route('admin.expenses.store') }}" method="POST"
          class="space-y-4 bg-gray-800 p-6 rounded">

        @csrf

        <div>
            <label class="text-sm">Category</label>
            <input type="text" name="category"
                   class="w-full bg-gray-700 px-3 py-2 rounded" required>
        </div>

        <div>
            <label class="text-sm">Amount (UGX)</label>
            <input type="number" step="0.01" name="amount"
                   class="w-full bg-gray-700 px-3 py-2 rounded" required>
        </div>

        <div>
            <label class="text-sm">Expense Date</label>
            <input type="date" name="expense_date"
                   class="w-full bg-gray-700 px-3 py-2 rounded" required>
        </div>

        <div>
            <label class="text-sm">Description</label>
            <textarea name="description" rows="3"
                      class="w-full bg-gray-700 px-3 py-2 rounded"></textarea>
        </div>

        <button class="bg-blue-600 px-4 py-2 rounded hover:bg-blue-700">Save</button>
    </form>
</div>
@endsection
