@extends('layouts.admin')

@section('content')
<div class="p-6 space-y-6">

    <h2 class="text-3xl font-semibold text-gray-100 mb-6">Admin Dashboard</h2>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">

        <div class="bg-blue-700 p-5 rounded-lg shadow text-white">
            <p class="text-sm uppercase text-blue-200">Total Users</p>
            <h3 class="text-3xl font-bold mt-2">{{ $userCount }}</h3>
        </div>

        <div class="bg-green-700 p-5 rounded-lg shadow text-white">
            <p class="text-sm uppercase text-green-200">Total Members</p>
            <h3 class="text-3xl font-bold mt-2">{{ $memberCount }}</h3>
        </div>

        <div class="bg-purple-700 p-5 rounded-lg shadow text-white">
            <p class="text-sm uppercase text-purple-200">Total Admins</p>
            <h3 class="text-3xl font-bold mt-2">{{ $adminCount }}</h3>
        </div>

        <div class="bg-yellow-700 p-5 rounded-lg shadow text-white">
            <p class="text-sm uppercase text-yellow-200">Total Accounts</p>
            <h3 class="text-3xl font-bold mt-2">{{ $accountCount }}</h3>
        </div>

    </div>

    <!-- Financial Summary -->
    <div class="grid grid-cols-1 sm:grid-cols-3 gap-6">
        <div class="bg-gray-800 p-6 rounded-lg shadow mt-6">
    <h3 class="text-xl font-semibold text-gray-100 mb-4">Financial Trend (Last 12 Months)</h3>

    <canvas id="financialChart" height="100"></canvas>
</div>


         <div class="bg-gray-800 p-6 rounded-lg shadow mt-6">
            <p class="text-sm uppercase text-gray-400">Total Deposits</p>
            <h3 class="text-3xl font-bold text-green-400 mt-2">UGX {{ number_format($totalDeposits) }}</h3>
       <p class="text-sm uppercase text-gray-400">Total Withdrawals</p>
            <h3 class="text-3xl font-bold text-red-400 mt-2">UGX {{ number_format($totalWithdrawals) }}</h3>
        

        </div>

         <div class="bg-gray-800 p-6 rounded-lg shadow mt-6">
            <p class="text-sm uppercase text-gray-400">Net Balance</p>
            <h3 class="text-3xl font-bold text-blue-300 mt-2">UGX {{ number_format($netBalance) }}</h3>
        </div>


    </div>


    <!-- LOAN STATS -->
<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 mt-6">

    <div class="bg-indigo-700 p-5 rounded-lg shadow text-white">
        <p class="text-sm uppercase text-indigo-200">Total Loan Applications</p>
        <h3 class="text-3xl font-bold mt-2">{{ $totalLoans }}</h3>
    </div>

    <div class="bg-yellow-600 p-5 rounded-lg shadow text-white">
        <p class="text-sm uppercase text-yellow-100">Pending Loans</p>
        <h3 class="text-3xl font-bold mt-2">{{ $pendingLoans }}</h3>
    </div>

    <div class="bg-green-700 p-5 rounded-lg shadow text-white">
        <p class="text-sm uppercase text-green-200">Approved Loans</p>
        <h3 class="text-3xl font-bold mt-2">{{ $approvedLoans }}</h3>
    </div>

    <div class="bg-blue-700 p-5 rounded-lg shadow text-white">
        <p class="text-sm uppercase text-blue-200">Disbursed Loans</p>
        <h3 class="text-3xl font-bold mt-2">{{ $disbursedLoans }}</h3>
    </div>

    <div class="bg-red-700 p-5 rounded-lg shadow text-white">
        <p class="text-sm uppercase text-red-200">Rejected Loans</p>
        <h3 class="text-3xl font-bold mt-2">{{ $rejectedLoans }}</h3>
    </div>

    <div class="bg-gray-600 p-5 rounded-lg shadow text-white">
        <p class="text-sm uppercase text-gray-200">Closed Loans</p>
        <h3 class="text-3xl font-bold mt-2">{{ $closedLoans }}</h3>
    </div>

</div>


    <hr class="border-gray-700">

    <!-- Recent Users + Activity -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">

        <!-- Recent Users -->
        <div class="bg-gray-800 p-6 rounded-lg shadow">
            <h3 class="text-lg font-semibold text-gray-100 mb-4">Recent Users</h3>

            <table class="min-w-full text-sm text-gray-300">
                <thead class="bg-gray-700 text-gray-100">
                    <tr>
                        <th class="py-2 px-3">Name</th>
                        <th class="py-2 px-3">Role</th>
                        <th class="py-2 px-3">Email</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($recentUsers as $user)
                        <tr class="border-t border-gray-700 hover:bg-gray-700">
                            <td class="py-2 px-3">{{ $user->name }}</td>
                            <td class="py-2 px-3 capitalize">{{ $user->role }}</td>
                            <td class="py-2 px-3">{{ $user->email }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Recent Accounts -->
        <div class="bg-gray-800 p-6 rounded-lg shadow">
            <h3 class="text-lg font-semibold text-gray-100 mb-4">Recent Accounts</h3>

            <table class="min-w-full text-sm text-gray-300">
                <thead class="bg-gray-700 text-gray-100">
                    <tr>
                        <th class="py-2 px-3">Account</th>
                        <th class="py-2 px-3">Member</th>
                        <th class="py-2 px-3">Status</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($recentAccounts as $acc)
                        <tr class="border-t border-gray-700 hover:bg-gray-700">
                            <td class="py-2 px-3">{{ $acc->account_number }}</td>
                            <td class="py-2 px-3">{{ $acc->user->name ?? 'N/A' }}</td>
                            <td class="py-2 px-3">
                                <span class="text-{{ $acc->status == 'active' ? 'green' : 'red' }}-400">
                                    {{ ucfirst($acc->status) }}
                                </span>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

    </div>

    <!-- RECENT TRANSACTIONS -->
    <div class="bg-gray-800 p-6 rounded-lg shadow">
        <h3 class="text-lg font-semibold text-gray-100 mb-4">Recent Transactions</h3>

        <table class="min-w-full text-sm text-gray-300">
            <thead class="bg-gray-700 text-gray-100">
                <tr>
                    <th class="py-2 px-3">Date</th>
                    <th class="py-2 px-3">Type</th>
                    <th class="py-2 px-3">Amount</th>
                    <th class="py-2 px-3">Account</th>
                </tr>
            </thead>
            <tbody>
                @foreach($recentTransactions as $tx)
                    <tr class="border-t border-gray-700 hover:bg-gray-700">
                        <td class="py-2 px-3">{{ $tx->created_at->format('Y-m-d H:i') }}</td>
                        <td class="py-2 px-3 capitalize">{{ $tx->type }}</td>
                        <td class="py-2 px-3">UGX {{ number_format($tx->amount) }}</td>
                        <td class="py-2 px-3">{{ $tx->account->account_number }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>

    </div>

</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
@if(isset($chartLabels))
<script>
document.addEventListener("DOMContentLoaded", function () {

    const canvas = document.getElementById('financialChart');

    if (!canvas) {
        console.error("financialChart canvas NOT found!");
        return;
    }

    const ctx = canvas.getContext('2d');

    new Chart(ctx, {
        type: 'line',
        data: {
            labels: @json($chartLabels),
            datasets: [
                {
                    label: "Deposits",
                    data: @json($chartDeposits),
                    borderColor: "rgba(34, 197, 94, 1)",
                    backgroundColor: "rgba(34, 197, 94, 0.2)",
                    borderWidth: 2,
                    tension: 0.3
                },
                {
                    label: "Withdrawals",
                    data: @json($chartWithdrawals),
                    borderColor: "rgba(239, 68, 68, 1)",
                    backgroundColor: "rgba(239, 68, 68, 0.2)",
                    borderWidth: 2,
                    tension: 0.3
                }
            ]
        }
    });

});
</script>
@endif


@endsection
