@extends('layouts.admin')

@section('content')
<div class="container mx-auto px-6 py-6">

   <div class="flex justify-between items-center mb-6">
    <h1 class="text-2xl font-bold text-white">Accounts</h1>

    <div class="flex gap-3">
        <a href="{{ route('admin.accounts.export.csv') }}"
           class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded shadow">
            ⬇ Export CSV
        </a>
        <a href="{{ route('admin.accounts.export.excel', request()->query()) }}"
   class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded shadow">
    ⬇ Export Excel
</a>


        <a href="{{ route('admin.accounts.create') }}"
           class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded shadow">
            + Add Account
        </a>
    </div>
</div>


    <!-- Filter + Search Bar -->
    <form method="GET" action="{{ route('admin.accounts.index') }}"
          class="flex flex-wrap gap-4 bg-gray-800 p-4 rounded-lg mb-6">

        <!-- Search -->
        <div class="relative flex-1 min-w-[250px]">
            <span class="absolute inset-y-0 left-3 flex items-center text-gray-400">
                🔍
            </span>
            <input type="text"
                   name="search"
                   value="{{ request('search') }}"
                   placeholder="Search accounts or members..."
                   class="w-full pl-10 pr-3 py-2 bg-gray-700 text-white rounded focus:ring-2 focus:ring-blue-600">
        </div>

        <!-- Account Type Filter -->
        <select name="type"
                class="bg-gray-700 text-white px-3 py-2 rounded min-w-[150px]">
            <option value="">All Types</option>
            @foreach($types as $type)
                <option value="{{ $type->id }}" {{ request('type') == $type->id ? 'selected' : '' }}>
                    {{ $type->name }}
                </option>
            @endforeach
        </select>

        <!-- Status Filter -->
        <select name="status"
                class="bg-gray-700 text-white px-3 py-2 rounded min-w-[150px]">
            <option value="">All Status</option>
            <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
            <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
        </select>

        <!-- Apply -->
        <button class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">
            Apply
        </button>
    </form>

    <!-- Accounts Table -->
    <div class="bg-gray-800 text-gray-200 rounded-lg shadow overflow-hidden">
        <table class="w-full">
            <thead class="bg-blue-700 text-white uppercase text-sm">
                <tr>
                    <th class="px-4 py-3 text-left">Account No</th>
                    <th class="px-4 py-3 text-left">Member</th>
                    <th class="px-4 py-3 text-left">Type</th>
                    <th class="px-4 py-3 text-left">Balance</th>
                    <th class="px-4 py-3 text-left">Status</th>
                    <th class="px-4 py-3 text-left">Actions</th>
                </tr>
            </thead>

            <tbody>
                @forelse($accounts as $account)
                <tr class="border-b border-gray-700">

                    <td class="px-4 py-3 font-semibold">
                       <a href="{{ route('admin.accounts.show', $account->id) }}"
       class="text-blue-400 hover:text-blue-600 font-semibold">
        {{ $account->account_number }}
    </a>
                    </td>

                    <td class="px-4 py-3">
                        {{ $account->user->name }}
                        <div class="text-gray-400 text-sm">{{ $account->user->email }}</div>
                    </td>

                    <td class="px-4 py-3">
                        {{ $account->type->name }}
                    </td>

                    <td class="px-4 py-3">
                        UGX {{ number_format($account->balance) }}
                    </td>

                    <td class="px-4 py-3">
                        @if($account->status == 'active')
                            <span class="text-green-400 font-semibold">Active</span>
                        @else
                            <span class="text-red-400 font-semibold">Inactive</span>
                        @endif
                    </td>

                    <td class="px-4 py-3 space-x-3">

                        <a href="{{ route('admin.accounts.edit', $account->id) }}"
                           class="text-blue-400 hover:text-blue-600">Edit</a>

                        <form action="{{ route('admin.accounts.toggle_status', $account->id) }}"
                              method="POST" class="inline">
                            @csrf
                            <button class="text-yellow-400 hover:text-yellow-600">
                                {{ $account->status == 'active' ? 'Deactivate' : 'Activate' }}
                            </button>
                        </form>

                        <form action="{{ route('admin.accounts.destroy', $account->id) }}"
                              method="POST" class="inline"
                              onsubmit="return confirm('Delete this account?');">
                            @csrf
                            @method('DELETE')
                            <button class="text-red-400 hover:text-red-600">Delete</button>
                        </form>

                    </td>

                </tr>
                @empty

                <tr>
                    <td colspan="6" class="px-4 py-6 text-center text-gray-400">
                        No accounts found.
                    </td>
                </tr>

                @endforelse

            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="mt-6">
        {{ $accounts->links('pagination::tailwind') }}
    </div>

</div>
@endsection
