@extends('layouts.admin')

@section('content')
<div class="container mx-auto px-6 py-6">

    <h1 class="text-2xl font-bold text-white text-center mb-6">
        Add Account
    </h1>

    <div class="max-w-2xl mx-auto bg-gray-800 p-8 rounded-lg shadow">

        <form action="{{ route('admin.accounts.store') }}" method="POST">
            @csrf

            {{-- Auto-generated Account Number Display --}}
            <div class="mb-4">
                <label class="block text-gray-300 mb-2">Account Number</label>
                <input type="text"
                       value="{{ $generated ?? 'HCS-XXXXXX' }}"
                       class="w-full p-2 bg-gray-700 text-gray-400 rounded"
                       readonly>
                <p class="text-xs text-gray-500 mt-1">This number is automatically generated.</p>
            </div>

            {{-- Member --}}
            <div class="mb-4">
                <label class="block text-gray-300 mb-2">Member</label>
                <select name="user_id"
                        class="w-full p-2 bg-gray-700 text-white rounded" required>
                    <option value="">-- Select Member --</option>
                    @foreach($members as $member)
                        <option value="{{ $member->id }}">
                            {{ $member->name }} ({{ $member->email }})
                        </option>
                    @endforeach
                </select>
            </div>

            {{-- Account Type --}}
            <div class="mb-4">
                <label class="block text-gray-300 mb-2">Account Type</label>
                <select name="account_type_id"
                        class="w-full p-2 bg-gray-700 text-white rounded" required>
                    <option value="">-- Select Type --</option>
                    @foreach($types as $type)
                        <option value="{{ $type->id }}">
                            {{ $type->name }}
                        </option>
                    @endforeach
                </select>
            </div>

            {{-- Notes / Description --}}
            <div class="mb-6">
                <label class="block text-gray-300 mb-2">Notes / Description (Optional)</label>
                <textarea 
                    name="notes"
                    rows="3"
                    class="w-full p-2 bg-gray-700 text-gray-200 rounded"
                    placeholder="Add any notes about this account such as initial fees, special terms, restrictions, or opening remarks..."
                ></textarea>
            </div>

            {{-- Submit --}}
            <div class="flex items-center gap-4">
                <button type="submit"
                        class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">
                    Create Account
                </button>

                <a href="{{ route('admin.accounts.index') }}"
                   class="text-gray-400 hover:text-gray-200">
                    Cancel
                </a>
            </div>

        </form>

    </div>

</div>
@endsection
