@extends('layouts.admin')

@section('content')
<div class="container mx-auto px-6 py-6">

    <h1 class="text-2xl font-bold text-white mb-6">Create Account Type</h1>

    <form action="{{ route('admin.account_types.store') }}" method="POST"
          class="bg-gray-800 p-6 rounded-lg">
        @csrf

        <div class="mb-4">
            <label class="block text-gray-300 mb-1">Type Name</label>
            <input type="text" name="name"
                class="w-full p-2 rounded bg-gray-700 text-white"
                placeholder="Savings, Shares, Loan..." required>
        </div>

        <div class="mb-4">
            <label class="block text-gray-300 mb-1">Minimum Balance</label>
            <input type="number" step="0.01" name="min_balance"
                class="w-full p-2 rounded bg-gray-700 text-white" required>
        </div>

        <div class="mb-4">
            <label class="block text-gray-300 mb-1">Interest Rate (%)</label>
            <input type="number" step="0.1" name="interest_rate"
                class="w-full p-2 rounded bg-gray-700 text-white" required>
        </div>

        <div class="mb-4">
            <label class="block text-gray-300 mb-1">Has Interest?</label>
            <select name="has_interest"
                    class="w-full p-2 rounded bg-gray-700 text-white" required>
                <option value="1">Yes</option>
                <option value="0">No</option>
            </select>
        </div>

        <button type="submit"
                class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">
            Save
        </button>

    </form>
</div>
@endsection
