<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up()
{
    Schema::create('incomes', function (Blueprint $table) {
        $table->id();
        $table->unsignedBigInteger('income_type_id');
        $table->unsignedBigInteger('member_id')->nullable(); // optional
        $table->unsignedBigInteger('admin_id');
        $table->decimal('amount', 12, 2);
        $table->string('description')->nullable();
        $table->timestamps();

        $table->foreign('income_type_id')->references('id')->on('income_types')->onDelete('cascade');
        $table->foreign('member_id')->references('id')->on('users')->onDelete('set null');
        $table->foreign('admin_id')->references('id')->on('users')->onDelete('cascade');
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('incomes');
    }
};
