<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
 public function up()
{
    Schema::create('share_transactions', function (Blueprint $table) {
        $table->id();
        $table->unsignedBigInteger('user_id');
        $table->integer('shares'); // number of share units purchased
        $table->decimal('amount', 12, 2); // total amount paid
        $table->decimal('price_per_share', 12, 2); // e.g. UGX 10,000 per share
        $table->string('reference')->nullable();
        $table->text('notes')->nullable();
        $table->unsignedBigInteger('admin_id'); // recorded by
        $table->timestamps();

        $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        $table->foreign('admin_id')->references('id')->on('users')->onDelete('cascade');
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('share_transactions');
    }
};
