<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up()
{
    Schema::create('expenses', function (Blueprint $table) {
        $table->id();
        $table->string('category');              // e.g. Transport, Fuel, Office Supplies
        $table->text('description')->nullable(); // Optional notes
        $table->decimal('amount', 12, 2);        // Money spent
        $table->date('expense_date');            // When the expense occurred
        $table->unsignedBigInteger('recorded_by'); // Admin user

        $table->timestamps();

        $table->foreign('recorded_by')->references('id')->on('users')->onDelete('cascade');
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('expenses');
    }
};
