<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('loans', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('user_id');     // borrower
            $table->unsignedBigInteger('loan_type_id'); // type of loan

            // Main loan fields
            $table->decimal('principal', 15, 2);        // amount requested
            $table->decimal('interest_rate', 8, 2)->default(0);
            $table->decimal('total_payable', 15, 2)->nullable();
            $table->decimal('balance', 15, 2)->nullable();

            // Loan duration
            $table->integer('term_months')->nullable();

            // Optional asset field for asset financing
            $table->decimal('asset_value', 15, 2)->nullable();

            $table->text('purpose')->nullable();
            $table->text('admin_notes')->nullable();

            // Loan process workflow
            $table->string('status')->default('pending'); // pending, approved, active, closed, rejected

            $table->decimal('approved_amount', 15, 2)->nullable();
            $table->unsignedBigInteger('approved_by')->nullable();
            $table->timestamp('approved_at')->nullable();

            $table->timestamp('disbursed_at')->nullable();
            $table->unsignedBigInteger('disbursed_by')->nullable();

            $table->longText('amortization_schedule')->nullable();

            $table->timestamps();

            // Foreign keys
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('loan_type_id')->references('id')->on('loan_types')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('loans');
    }
};
