<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
public function up(): void
{
Schema::create('group_loan_repayments', function (Blueprint $table) {
$table->id();
$table->unsignedBigInteger('group_loan_id');
$table->unsignedBigInteger('member_id');
$table->decimal('amount', 12, 2);
$table->timestamp('payment_date');
$table->timestamps();
$table->foreign('group_loan_id')->references('id')->on('group_loans')->onDelete('cascade');
$table->foreign('member_id')->references('id')->on('users')->onDelete('cascade');
});
}


public function down(): void
{
Schema::dropIfExists('group_loan_repayments');
}
};
