<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
public function up(): void
{
Schema::create('group_loans', function (Blueprint $table) {
$table->id();
$table->unsignedBigInteger('group_id');
$table->decimal('principal', 12, 2);
$table->decimal('interest_rate', 5, 2);
$table->integer('loan_period_months');
$table->decimal('balance', 12, 2);
$table->string('status')->default('pending');
$table->timestamp('disbursed_at')->nullable();
$table->timestamps();
$table->foreign('group_id')->references('id')->on('groups')->onDelete('cascade');
});
}


public function down(): void
{
Schema::dropIfExists('group_loans');
}
};