<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLoanTypesTable extends Migration
{
    public function up()
    {
        Schema::create('loan_types', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->unique();
            $table->text('description')->nullable();
            $table->decimal('interest_rate', 8, 3)->default(0); // percent, e.g., 2.5
            $table->integer('duration_months')->nullable();
            $table->decimal('min_amount', 15, 2)->nullable();
            $table->decimal('max_amount', 15, 2)->nullable();

            // rule engine json for flexible rules (min savings percent, min_daily_saving_days, etc.)
            $table->json('rules')->nullable();

            // control flags
            $table->boolean('allow_member_application')->default(true);
            $table->boolean('allow_admin_application')->default(true);
            $table->boolean('is_group_loan')->default(false);

            $table->enum('status', ['active','inactive'])->default('active');

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('loan_types');
    }
}
