<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGroupMembersTable extends Migration
{
    public function up()
    {
        Schema::create('group_members', function (Blueprint $table) {
            $table->id();
            $table->foreignId('group_id')->constrained('groups')->onDelete('cascade');
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->enum('status', ['active','inactive'])->default('active');
            $table->timestamps();

            $table->unique(['group_id','user_id'], 'group_user_unique');
        });
    }

    public function down()
    {
        Schema::dropIfExists('group_members');
    }
}
