<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up()
{
    Schema::create('accounts', function (Blueprint $table) {
        $table->id();
        $table->string('account_number')->unique();
        $table->unsignedBigInteger('user_id');   // member ID
        $table->unsignedBigInteger('account_type_id');
        $table->decimal('balance', 16, 2)->default(0);
        $table->enum('status', ['active', 'inactive'])->default('active');
        $table->timestamps();

        $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        $table->foreign('account_type_id')->references('id')->on('account_types')->onDelete('cascade');
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('accounts');
    }
};
