<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
  public function up()
{
    Schema::create('account_types', function (Blueprint $table) {
        $table->id();
        $table->string('name')->unique(); // Savings, Shares, Loan
        $table->decimal('min_balance', 16, 2)->default(0);
        $table->decimal('interest_rate', 8, 2)->default(0);
        $table->boolean('has_interest')->default(false);
        $table->timestamps();
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('account_types');
    }
};
