<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ShareTransaction extends Model
{
    protected $fillable = [
        'user_id',
        'shares',
        'amount',
        'price_per_share',
        'reference',
        'notes',
        'admin_id',
    ];

    public function member()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function admin()
    {
        return $this->belongsTo(User::class, 'admin_id');
    }
}