<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LoanRepayment extends Model
{
    use HasFactory;

   protected $fillable = [
    'loan_id',
    'account_id',
    'admin_id',
    'amount',
    'balance_before',
    'balance_after',
    'reference',
    'notes',
    'due_date',
    'status',
];


    public function loan() { return $this->belongsTo(Loan::class); }
    public function admin() { return $this->belongsTo(User::class, 'admin_id'); }
    public function account() { return $this->belongsTo(Account::class); }
}
