<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class LoanApplicationRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'loan_type_id' => 'required|exists:loan_types,id',
            'amount' => 'required|numeric|min:1',

            'asset_value' => 'nullable|numeric|min:1',
            'group_id' => 'nullable|exists:groups,id',

            'term_months' => 'nullable|numeric|min:1',
            'purpose' => 'nullable|string|max:500',
        ];
    }
}
