<?php

namespace App\Http\Controllers;

use App\Models\IncomeType;
use Illuminate\Http\Request;

class IncomeTypeController extends Controller
{
    public function index()
    {
        $types = IncomeType::latest()->paginate(10);
        return view('admin.income_types.index', compact('types'));
    }

    public function create()
    {
        return view('admin.income_types.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string'
        ]);

        IncomeType::create($request->only('name', 'description'));

        return redirect()->route('admin.income_types.index')
                         ->with('success', 'Income type created successfully.');
    }

    public function edit(IncomeType $incomeType)
    {
        return view('admin.income_types.edit', compact('incomeType'));
    }

    public function update(Request $request, IncomeType $incomeType)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string'
        ]);

        $incomeType->update($request->only('name', 'description'));

        return redirect()->route('admin.income_types.index')
                         ->with('success', 'Income type updated.');
    }

    public function destroy(IncomeType $incomeType)
    {
        $incomeType->delete();

        return back()->with('success', 'Income type deleted.');
    }
}
